/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.math;

import java.math.BigInteger;
import java.util.List;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.math.Arrangement;
import org.dromara.hutool.core.math.Combination;
import org.dromara.hutool.core.math.Money;
import org.dromara.hutool.core.text.StrUtil;

public class MathUtil {
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    public static long arrangementCount(int n, int m) {
        return Arrangement.count(n, m);
    }

    public static long arrangementCount(int n) {
        return Arrangement.count(n);
    }

    public static List<String[]> arrangementSelect(String[] datas, int m) {
        return new Arrangement(datas).select(m);
    }

    public static List<String[]> arrangementSelect(String[] datas) {
        return new Arrangement(datas).select();
    }

    public static long combinationCount(int n, int m) {
        return Combination.count(n, m);
    }

    public static List<String[]> combinationSelect(String[] datas, int m) {
        return new Combination(datas).select(m);
    }

    public static long yuanToCent(double yuan) {
        return new Money(yuan).getCent();
    }

    public static double centToYuan(long cent) {
        long yuan = cent / 100L;
        int centPart = (int)(cent % 100L);
        return new Money(yuan, centPart).getAmount().doubleValue();
    }

    public static BigInteger factorial(BigInteger n) {
        if (n.equals(BigInteger.ZERO)) {
            return BigInteger.ONE;
        }
        return MathUtil.factorial(n, BigInteger.ZERO);
    }

    public static BigInteger factorial(BigInteger start, BigInteger end) {
        Assert.notNull(start, "Factorial start must be not null!", new Object[0]);
        Assert.notNull(end, "Factorial end must be not null!", new Object[0]);
        if (start.compareTo(BigInteger.ZERO) < 0 || end.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(StrUtil.format("Factorial start and end both must be > 0, but got start={}, end={}", start, end));
        }
        if (start.equals(BigInteger.ZERO)) {
            start = BigInteger.ONE;
        }
        if (end.compareTo(BigInteger.ONE) < 0) {
            end = BigInteger.ONE;
        }
        BigInteger result = start;
        end = end.add(BigInteger.ONE);
        while (start.compareTo(end) > 0) {
            start = start.subtract(BigInteger.ONE);
            result = result.multiply(start);
        }
        return result;
    }

    public static long factorial(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException(StrUtil.format("Factorial start and end both must be >= 0, but got start={}, end={}", start, end));
        }
        if (0L == start || start == end) {
            return 1L;
        }
        if (start < end) {
            return 0L;
        }
        return MathUtil.factorialMultiplyAndCheck(start, MathUtil.factorial(start - 1L, end));
    }

    private static long factorialMultiplyAndCheck(long a, long b) {
        if (a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new IllegalArgumentException(StrUtil.format("Overflow in multiplication: {} * {}", a, b));
    }

    public static long factorial(long n) {
        if (n < 0L || n > 20L) {
            throw new IllegalArgumentException(StrUtil.format("Factorial must have n >= 0 and n <= 20 for n!, but got n = {}", n));
        }
        return FACTORIALS[(int)n];
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int processMultiple(int selectNum, int minNum) {
        int result = MathUtil.mathSubNode(selectNum, minNum) / MathUtil.mathNode(selectNum - minNum);
        return result;
    }

    public static int gcd(int a, int b) {
        Assert.isTrue(a >= 0, "a must be >= 0", new Object[0]);
        Assert.isTrue(b >= 0, "b must be >= 0", new Object[0]);
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            int delta = a - b;
            int minDeltaOrZero = delta & delta >> 31;
            a = delta - minDeltaOrZero - minDeltaOrZero;
            b += minDeltaOrZero;
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << Math.min(aTwos, bTwos);
    }

    public static int multiple(int m, int n) {
        return m * n / MathUtil.gcd(m, n);
    }

    private static int mathSubNode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * MathUtil.mathSubNode(selectNum - 1, minNum);
    }

    private static int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * MathUtil.mathNode(selectNum - 1);
    }
}

