/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.dromara.hutool.core.annotation.Alias;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.reference.WeakConcurrentMap;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.FieldReflect;
import org.dromara.hutool.core.reflect.ReflectUtil;
import org.dromara.hutool.core.text.StrUtil;

public class FieldUtil {
    private static final WeakConcurrentMap<Class<?>, FieldReflect> FIELDS_CACHE = new WeakConcurrentMap();

    static synchronized void clearCache() {
        FIELDS_CACHE.clear();
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != FieldUtil.getField(beanClass, name);
    }

    public static String getFieldName(Field field) {
        return FieldUtil.getFieldName(field, true);
    }

    public static String getFieldName(Field field, boolean useAlias) {
        Alias alias;
        if (null == field) {
            return null;
        }
        if (useAlias && null != (alias = field.getAnnotation(Alias.class))) {
            return alias.value();
        }
        return field.getName();
    }

    public static Field getDeclearField(Class<?> beanClass, String name) {
        Field[] fields = FieldUtil.getDeclaredFields(beanClass, field -> StrUtil.equals(name, field.getName()));
        return ArrayUtil.isEmpty(fields) ? null : fields[0];
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = FieldUtil.getFields(beanClass, field -> StrUtil.equals(name, field.getName()));
        return ArrayUtil.isEmpty(fields) ? null : fields[0];
    }

    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields = FieldUtil.getFields(beanClass);
        HashMap<String, Field> map = MapUtil.newHashMap(fields.length, true);
        for (Field field : fields) {
            map.putIfAbsent(field.getName(), field);
        }
        return map;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        return FieldUtil.getFields(beanClass, null);
    }

    public static Field[] getFields(Class<?> beanClass, Predicate<Field> fieldPredicate) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getAllFields(fieldPredicate);
    }

    public static Field[] getDeclaredFields(Class<?> beanClass, Predicate<Field> fieldPredicate) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getDeclaredFields(fieldPredicate);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        return FieldReflect.of(beanClass).getFieldsDirectly(withSuperClassFields);
    }

    public static Object getFieldValue(Object obj, String fieldName) throws HutoolException {
        if (null == obj || StrUtil.isBlank(fieldName)) {
            return null;
        }
        return FieldUtil.getFieldValue(obj, FieldUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getStaticFieldValue(Field field) throws HutoolException {
        return FieldUtil.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object obj, Field field) throws HutoolException {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtil.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object obj) {
        return FieldUtil.getFieldsValue(obj, null);
    }

    public static Object[] getFieldsValue(Object obj, Predicate<Field> filter) {
        Field[] fields;
        if (null != obj && null != (fields = FieldUtil.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass(), filter))) {
            return ArrayUtil.mapToArray(fields, field -> FieldUtil.getFieldValue(obj, field), Object[]::new);
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws HutoolException {
        Assert.notNull(obj, "Object must be not null !", new Object[0]);
        Assert.notBlank(fieldName);
        Field field = FieldUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        FieldUtil.setFieldValue(obj, field, value);
    }

    public static void setStaticFieldValue(Field field, Object value) throws HutoolException {
        FieldUtil.setFieldValue(null, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws HutoolException {
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = ConvertUtil.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassUtil.getDefaultValue(fieldType);
        }
        FieldUtil.setFieldValueExact(obj, field, value);
    }

    public static void setFieldValueExact(Object obj, Field field, Object value) throws HutoolException {
        ReflectUtil.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e, "IllegalAccess for [{}.{}]", null == obj ? field.getDeclaringClass() : obj, field.getName());
        }
    }
}

