/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.func.FunctionPool;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.dromara.hutool.core.text.StrPool;
import org.dromara.hutool.core.text.TextSimilarity;
import org.dromara.hutool.core.util.CharsetUtil;

public class StrUtil
extends CharSequenceUtil
implements StrPool {
    public static boolean isBlankIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = StrUtil.trim(str);
        }
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.UTF_8);
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof char[]) {
            return new String((char[])obj);
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrUtil.str(bytes, charset);
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String strFast(char[] value) {
        return FunctionPool.createString(value);
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static String reverse(String str) {
        return new String(ArrayUtil.reverse(str.toCharArray()));
    }

    public static String fillBefore(String str, char filledChar, int len) {
        return StrUtil.fill(str, filledChar, len, true);
    }

    public static String fillAfter(String str, char filledChar, int len) {
        return StrUtil.fill(str, filledChar, len, false);
    }

    public static String fill(String str, char filledChar, int len, boolean isPre) {
        int strLen = str.length();
        if (strLen > len) {
            return str;
        }
        String filledStr = StrUtil.repeat(filledChar, len - strLen);
        return isPre ? filledStr.concat(str) : str.concat(filledStr);
    }

    public static double similar(String str1, String str2) {
        return TextSimilarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return TextSimilarity.similar(str1, str2, scale);
    }
}

