/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.finder;

import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.dromara.hutool.core.text.finder.TextFinder;

public class StrFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final CharSequence strToFind;
    private final boolean caseInsensitive;

    public static StrFinder of(CharSequence strToFind, boolean caseInsensitive) {
        return new StrFinder(strToFind, caseInsensitive);
    }

    public StrFinder(CharSequence strToFind, boolean caseInsensitive) {
        Assert.notEmpty(strToFind);
        this.strToFind = strToFind;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int subLen = this.strToFind.length();
        if (from < 0) {
            from = 0;
        }
        int endLimit = this.getValidEndIndex();
        if (this.negative) {
            for (int i = from; i > endLimit; --i) {
                if (!CharSequenceUtil.isSubEquals(this.text, i, this.strToFind, 0, subLen, this.caseInsensitive)) continue;
                return i;
            }
        } else {
            endLimit = endLimit - subLen + 1;
            for (int i = from; i < endLimit; ++i) {
                if (!CharSequenceUtil.isSubEquals(this.text, i, this.strToFind, 0, subLen, this.caseInsensitive)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + this.strToFind.length();
    }
}

