/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.thread;

import java.time.Duration;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.thread.RetryableTask;

public class RetryUtil {
    public static void ofException(Runnable run, long maxAttempts, Duration delay, Runnable recover, Class<? extends Throwable> ... exs) {
        if (ArrayUtil.isEmpty(exs)) {
            exs = ArrayUtil.append(exs, new Class[]{RuntimeException.class});
        }
        RetryableTask.retryForExceptions(run, exs).maxAttempts(maxAttempts).delay(delay).execute().get().orElseGet(() -> {
            recover.run();
            return null;
        });
    }

    public static <T> T ofException(Supplier<T> sup, long maxAttempts, Duration delay, Supplier<T> recover, Class<? extends Throwable> ... exs) {
        if (ArrayUtil.isEmpty(exs)) {
            exs = ArrayUtil.append(exs, new Class[]{RuntimeException.class});
        }
        return RetryableTask.retryForExceptions(sup, exs).maxAttempts(maxAttempts).delay(delay).execute().get().orElseGet(recover);
    }

    public static void ofPredicate(Runnable run, long maxAttempts, Duration delay, Supplier<Void> recover, BiPredicate<Void, Throwable> predicate) {
        RetryableTask.retryForPredicate(run, predicate).delay(delay).maxAttempts(maxAttempts).execute().get().orElseGet(recover);
    }

    public static <T> T ofPredicate(Supplier<T> sup, long maxAttempts, Duration delay, Supplier<T> recover, BiPredicate<T, Throwable> predicate) {
        return RetryableTask.retryForPredicate(sup, predicate).delay(delay).maxAttempts(maxAttempts).execute().get().orElseGet(recover);
    }
}

