/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.img;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.swing.img.FontUtil;
import org.dromara.hutool.swing.img.ImgUtil;
import org.dromara.hutool.swing.img.RenderingHintsBuilder;
import org.dromara.hutool.swing.img.color.ColorUtil;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        if (null != color) {
            g.setColor(color);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g;
    }

    public static int getCenterY(Graphics g, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y;
    }

    public static Graphics drawStringColourful(Graphics g, String str, Font font, int width, int height) {
        return GraphicsUtil.drawStringColourful(g, str, font, width, height, null, 0);
    }

    public static Graphics drawStringColourful(Graphics g, String str, Font font, int width, int height, Color compareColor, int minColorDistance) {
        GraphicsUtil.enableAntialias(g);
        g.setFont(font);
        int midY = GraphicsUtil.getCenterY(g, height);
        int len = str.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            g.setColor(ColorUtil.randomColor(compareColor, minColorDistance));
            g.drawString(String.valueOf(str.charAt(i)), i * charWidth, midY);
        }
        return g;
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, int width, int height) {
        GraphicsUtil.enableAntialias(g);
        g.setFont(font);
        int midY = GraphicsUtil.getCenterY(g, height);
        int len = str.length();
        int charWidth = width / len;
        if (null != color) {
            g.setColor(color);
        }
        for (int i = 0; i < len; ++i) {
            g.drawString(String.valueOf(str.charAt(i)), i * charWidth, midY);
        }
        return g;
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, Rectangle rectangle) {
        Dimension dimension;
        int backgroundWidth = rectangle.width;
        int backgroundHeight = rectangle.height;
        try {
            dimension = FontUtil.getDimension(g.getFontMetrics(font), str);
        }
        catch (Exception e) {
            dimension = new Dimension(backgroundWidth / 3, backgroundHeight / 3);
        }
        rectangle.setSize(dimension.width, dimension.height);
        Point point = ImgUtil.getPointBaseCentre(rectangle, backgroundWidth, backgroundHeight);
        return GraphicsUtil.drawString(g, str, font, color, point);
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, Point point) {
        GraphicsUtil.enableAntialias(g);
        g.setFont(font);
        g.setColor((Color)ObjUtil.defaultIfNull((Object)color, (Object)Color.BLACK));
        g.drawString(str, point.x, point.y);
        return g;
    }

    public static Graphics drawImg(Graphics g, Image img, Point point) {
        g.drawImage(img, point.x, point.y, null);
        return g;
    }

    public static Graphics drawImg(Graphics g, Image img, Rectangle rectangle) {
        g.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        return g;
    }

    public static Graphics2D setAlpha(Graphics2D g, float alpha) {
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        return g;
    }

    private static void enableAntialias(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHints(RenderingHintsBuilder.of().setAntialiasing(RenderingHintsBuilder.Antialias.ON).setTextAntialias(RenderingHintsBuilder.TextAntialias.ON).build());
        }
    }
}

