/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

public final class Timer {
    private long timing;
    private long count;
    private long start;

    public void start() {
        assert (this.start == 0L) : "#start call misses a matching #stop call";
        ++this.count;
        this.start = System.nanoTime();
    }

    public void stop() {
        this.timing += Math.max(System.nanoTime() - this.start, 1L);
        this.start = 0L;
    }

    public long getCount() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        return this.count;
    }

    public long getTiming() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        return this.timing;
    }
}

