/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.Closeable;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasablePagedBytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.NotCompressedException;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractLifecycleRunnable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.TcpHeader;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.TransportStatus;

public abstract class TcpTransport<Channel>
extends AbstractLifecycleComponent
implements Transport {
    public static final String TRANSPORT_SERVER_WORKER_THREAD_NAME_PREFIX = "transport_server_worker";
    public static final String TRANSPORT_SERVER_BOSS_THREAD_NAME_PREFIX = "transport_server_boss";
    public static final String TRANSPORT_CLIENT_WORKER_THREAD_NAME_PREFIX = "transport_client_worker";
    public static final String TRANSPORT_CLIENT_BOSS_THREAD_NAME_PREFIX = "transport_client_boss";
    public static final Setting<TimeValue> PING_SCHEDULE = Setting.timeSetting("transport.ping_schedule", TimeValue.timeValueSeconds(-1L), Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_RECOVERY = Setting.intSetting("transport.connections_per_node.recovery", 2, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_BULK = Setting.intSetting("transport.connections_per_node.bulk", 3, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_REG = Setting.intSetting("transport.connections_per_node.reg", 6, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_STATE = Setting.intSetting("transport.connections_per_node.state", 1, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_PING = Setting.intSetting("transport.connections_per_node.ping", 1, 1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> TCP_CONNECT_TIMEOUT = Setting.timeSetting("transport.tcp.connect_timeout", NetworkService.TcpSettings.TCP_CONNECT_TIMEOUT, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_NO_DELAY = Setting.boolSetting("transport.tcp_no_delay", NetworkService.TcpSettings.TCP_NO_DELAY, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_KEEP_ALIVE = Setting.boolSetting("transport.tcp.keep_alive", NetworkService.TcpSettings.TCP_KEEP_ALIVE, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_REUSE_ADDRESS = Setting.boolSetting("transport.tcp.reuse_address", NetworkService.TcpSettings.TCP_REUSE_ADDRESS, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_BLOCKING_CLIENT = Setting.boolSetting("transport.tcp.blocking_client", NetworkService.TcpSettings.TCP_BLOCKING_CLIENT, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_BLOCKING_SERVER = Setting.boolSetting("transport.tcp.blocking_server", NetworkService.TcpSettings.TCP_BLOCKING_SERVER, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting("transport.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_SEND_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting("transport.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_RECEIVE_BUFFER_SIZE, Setting.Property.NodeScope);
    private static final long NINETY_PER_HEAP_SIZE = (long)((double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() * 0.9);
    private static final int PING_DATA_SIZE = -1;
    protected final boolean blockingClient;
    private final CircuitBreakerService circuitBreakerService;
    protected final ScheduledPing scheduledPing;
    private final TimeValue pingSchedule;
    protected final ThreadPool threadPool;
    private final BigArrays bigArrays;
    protected final NetworkService networkService;
    protected volatile TransportServiceAdapter transportServiceAdapter;
    protected final ConcurrentMap<DiscoveryNode, NodeChannels> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private final Set<NodeChannels> openConnections = ConcurrentCollections.newConcurrentSet();
    protected final Map<String, List<Channel>> serverChannels = ConcurrentCollections.newConcurrentMap();
    protected final ConcurrentMap<String, BoundTransportAddress> profileBoundAddresses = ConcurrentCollections.newConcurrentMap();
    protected final KeyedLock<String> connectionLock = new KeyedLock();
    private final NamedWriteableRegistry namedWriteableRegistry;
    protected final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    protected final boolean compress;
    protected volatile BoundTransportAddress boundAddress;
    private final String transportName;
    protected final ConnectionProfile defaultConnectionProfile;
    private final ConcurrentMap<Long, HandshakeResponseHandler> pendingHandshakes = new ConcurrentHashMap<Long, HandshakeResponseHandler>();
    private final AtomicLong requestIdGenerator = new AtomicLong();
    private final CounterMetric numHandshakes = new CounterMetric();
    private static final String HANDSHAKE_ACTION_NAME = "internal:tcp/handshake";
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::([\\d\\-]*))?$");

    public TcpTransport(String transportName, Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        super(settings);
        this.threadPool = threadPool;
        this.bigArrays = bigArrays;
        this.circuitBreakerService = circuitBreakerService;
        this.scheduledPing = new ScheduledPing();
        this.pingSchedule = PING_SCHEDULE.get(settings);
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.compress = Transport.TRANSPORT_TCP_COMPRESS.get(settings);
        this.networkService = networkService;
        this.transportName = transportName;
        this.blockingClient = TCP_BLOCKING_CLIENT.get(settings);
        this.defaultConnectionProfile = TcpTransport.buildDefaultConnectionProfile(settings);
    }

    static ConnectionProfile buildDefaultConnectionProfile(Settings settings) {
        int connectionsPerNodeRecovery = CONNECTIONS_PER_NODE_RECOVERY.get(settings);
        int connectionsPerNodeBulk = CONNECTIONS_PER_NODE_BULK.get(settings);
        int connectionsPerNodeReg = CONNECTIONS_PER_NODE_REG.get(settings);
        int connectionsPerNodeState = CONNECTIONS_PER_NODE_STATE.get(settings);
        int connectionsPerNodePing = CONNECTIONS_PER_NODE_PING.get(settings);
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.setConnectTimeout(TCP_CONNECT_TIMEOUT.get(settings));
        builder.setHandshakeTimeout(TCP_CONNECT_TIMEOUT.get(settings));
        builder.addConnections(connectionsPerNodeBulk, TransportRequestOptions.Type.BULK);
        builder.addConnections(connectionsPerNodePing, TransportRequestOptions.Type.PING);
        builder.addConnections(DiscoveryNode.isMasterNode(settings) ? connectionsPerNodeState : 0, TransportRequestOptions.Type.STATE);
        builder.addConnections(DiscoveryNode.isDataNode(settings) ? connectionsPerNodeRecovery : 0, TransportRequestOptions.Type.RECOVERY);
        builder.addConnections(connectionsPerNodeReg, TransportRequestOptions.Type.REG);
        return builder.build();
    }

    @Override
    protected void doStart() {
        if (this.pingSchedule.millis() > 0L) {
            this.threadPool.schedule(this.pingSchedule, "generic", this.scheduledPing);
        }
    }

    @Override
    public CircuitBreaker getInFlightRequestBreaker() {
        return this.circuitBreakerService.getBreaker("in_flight_requests");
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter service) {
        if (service.getRequestHandler(HANDSHAKE_ACTION_NAME) != null) {
            throw new IllegalStateException("internal:tcp/handshake is a reserved request handler and must not be registered");
        }
        this.transportServiceAdapter = service;
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, CheckedBiConsumer<Transport.Connection, ConnectionProfile, IOException> connectionValidator) throws ConnectTransportException {
        connectionProfile = TcpTransport.resolveConnectionProfile(connectionProfile, this.defaultConnectionProfile);
        if (node == null) {
            throw new ConnectTransportException(null, "can't connect to a null node");
        }
        this.globalLock.readLock().lock();
        try {
            this.ensureOpen();
            try (Releasable ignored = this.connectionLock.acquire(node.getId());){
                NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
                if (nodeChannels != null) {
                    return;
                }
                boolean success = false;
                try {
                    nodeChannels = this.openConnection(node, connectionProfile);
                    connectionValidator.accept(nodeChannels, connectionProfile);
                    this.connectedNodes.put(node, nodeChannels);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("connected to node [{}]", (Object)node);
                    }
                    this.transportServiceAdapter.onNodeConnected(node);
                    success = true;
                    if (success) return;
                }
                catch (ConnectTransportException e) {
                    try {
                        throw e;
                        catch (Exception e2) {
                            throw new ConnectTransportException(node, "general node connection failure", e2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        this.logger.trace(() -> new ParameterizedMessage("failed to connect to [{}], cleaning dangling connections", (Object)node));
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{nodeChannels});
                        throw throwable;
                    }
                }
                this.logger.trace(() -> new ParameterizedMessage("failed to connect to [{}], cleaning dangling connections", (Object)node));
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{nodeChannels});
                return;
            }
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    static ConnectionProfile resolveConnectionProfile(@Nullable ConnectionProfile connectionProfile, ConnectionProfile defaultConnectionProfile) {
        Objects.requireNonNull(defaultConnectionProfile);
        if (connectionProfile == null) {
            return defaultConnectionProfile;
        }
        if (connectionProfile.getConnectTimeout() != null && connectionProfile.getHandshakeTimeout() != null) {
            return connectionProfile;
        }
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder(connectionProfile);
        if (connectionProfile.getConnectTimeout() == null) {
            builder.setConnectTimeout(defaultConnectionProfile.getConnectTimeout());
        }
        if (connectionProfile.getHandshakeTimeout() == null) {
            builder.setHandshakeTimeout(defaultConnectionProfile.getHandshakeTimeout());
        }
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    @Override
    public final NodeChannels openConnection(DiscoveryNode node, ConnectionProfile connectionProfile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean disconnectFromNode(DiscoveryNode node, Channel channel, String reason) {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
        if (nodeChannels != null && nodeChannels.hasChannel(channel)) {
            try (Releasable ignored = this.connectionLock.acquire(node.getId());){
                nodeChannels = (NodeChannels)this.connectedNodes.get(node);
                if (nodeChannels != null && nodeChannels.hasChannel(channel)) {
                    this.connectedNodes.remove(node);
                    this.closeAndNotify(node, nodeChannels, reason);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndNotify(DiscoveryNode node, NodeChannels nodeChannels, String reason) {
        try {
            this.logger.debug("disconnecting from [{}], {}", (Object)node, (Object)reason);
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{nodeChannels});
        }
        finally {
            this.logger.trace("disconnected from [{}], {}", (Object)node, (Object)reason);
            this.transportServiceAdapter.onNodeDisconnected(node);
        }
    }

    protected final void disconnectFromNodeChannel(Channel channel, String reason) {
        this.threadPool.generic().execute(() -> {
            block14: {
                try {
                    if (this.isOpen(channel)) {
                        this.closeChannels(Collections.singletonList(channel));
                    }
                }
                catch (IOException e) {
                    try {
                        this.logger.warn("failed to close channel", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        block15: {
                            for (Map.Entry entry : this.connectedNodes.entrySet()) {
                                if (!this.disconnectFromNode((DiscoveryNode)entry.getKey(), channel, reason)) continue;
                                assert (!this.openConnections.contains(entry.getValue())) : "NodeChannel#close should remove the connetion";
                                break block15;
                            }
                            for (NodeChannels channels : this.openConnections) {
                                if (!channels.hasChannel(channel)) continue;
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{channels});
                                break;
                            }
                        }
                        throw throwable;
                    }
                    for (Map.Entry entry : this.connectedNodes.entrySet()) {
                        if (!this.disconnectFromNode((DiscoveryNode)entry.getKey(), channel, reason)) continue;
                        assert (!this.openConnections.contains(entry.getValue())) : "NodeChannel#close should remove the connetion";
                    }
                    for (NodeChannels channels : this.openConnections) {
                        if (!channels.hasChannel(channel)) continue;
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{channels});
                    }
                }
                for (Map.Entry entry : this.connectedNodes.entrySet()) {
                    if (!this.disconnectFromNode((DiscoveryNode)entry.getKey(), channel, reason)) continue;
                    assert (!this.openConnections.contains(entry.getValue())) : "NodeChannel#close should remove the connetion";
                    break block14;
                }
                for (NodeChannels channels : this.openConnections) {
                    if (!channels.hasChannel(channel)) continue;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{channels});
                    break;
                }
            }
        });
    }

    @Override
    public NodeChannels getConnection(DiscoveryNode node) {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
        if (nodeChannels == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return nodeChannels;
    }

    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        try (Releasable ignored = this.connectionLock.acquire(node.getId());){
            NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.remove(node);
            if (nodeChannels != null) {
                this.closeAndNotify(node, nodeChannels, "due to explicit disconnect call");
            }
        }
    }

    protected Version getCurrentVersion() {
        return Version.CURRENT;
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return InetSocketTransportAddress.class.equals(address);
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return Collections.unmodifiableMap(new HashMap<String, BoundTransportAddress>(this.profileBoundAddresses));
    }

    protected Map<String, Settings> buildProfileSettings() {
        Map<String, Settings> profiles = TransportSettings.TRANSPORT_PROFILES_SETTING.get(this.settings).getAsGroups(true);
        if (!profiles.containsKey("default")) {
            profiles = new HashMap<String, Settings>(profiles);
            profiles.put("default", Settings.EMPTY);
        }
        Settings defaultSettings = profiles.get("default");
        HashMap<String, Settings> result = new HashMap<String, Settings>();
        for (Map.Entry<String, Settings> entry : profiles.entrySet()) {
            Settings profileSettings = entry.getValue();
            String name = entry.getKey();
            if (!Strings.hasLength(name)) {
                this.logger.info("transport profile configured without a name. skipping profile with settings [{}]", (Object)profileSettings.toDelimitedString(','));
                continue;
            }
            if ("default".equals(name)) {
                profileSettings = Settings.builder().put(profileSettings).put("port", profileSettings.get("port", TransportSettings.PORT.get(this.settings))).build();
            } else if (profileSettings.get("port") == null) {
                this.logger.info("No port configured for profile [{}], not binding", (Object)name);
                continue;
            }
            Settings mergedSettings = Settings.builder().put(defaultSettings).put(profileSettings).build();
            result.put(name, mergedSettings);
        }
        return result;
    }

    @Override
    public List<String> getLocalAddresses() {
        ArrayList<String> local = new ArrayList<String>();
        local.add("127.0.0.1");
        if (NetworkUtils.SUPPORTS_V6) {
            local.add("[::1]");
        }
        return local;
    }

    protected void bindServer(String name, Settings settings) {
        InetAddress[] hostAddresses;
        Object[] bindHosts = settings.getAsArray("bind_host", null);
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses((String[])bindHosts);
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host " + Arrays.toString(bindHosts), e);
        }
        if (this.logger.isDebugEnabled()) {
            String[] addresses = new String[hostAddresses.length];
            for (int i = 0; i < hostAddresses.length; ++i) {
                addresses[i] = NetworkAddress.format(hostAddresses[i]);
            }
            this.logger.debug("binding server bootstrap to: {}", (Object)addresses);
        }
        assert (hostAddresses.length > 0);
        ArrayList<InetSocketAddress> boundAddresses = new ArrayList<InetSocketAddress>();
        for (InetAddress hostAddress : hostAddresses) {
            boundAddresses.add(this.bindToPort(name, hostAddress, settings.get("port")));
        }
        BoundTransportAddress boundTransportAddress = this.createBoundTransportAddress(name, settings, boundAddresses);
        if ("default".equals(name)) {
            this.boundAddress = boundTransportAddress;
        } else {
            this.profileBoundAddresses.put(name, boundTransportAddress);
        }
    }

    protected InetSocketAddress bindToPort(String name, InetAddress hostAddress, String port) {
        PortsRange portsRange = new PortsRange(port);
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(portNumber -> {
            try {
                Channel channel = this.bind(name, new InetSocketAddress(hostAddress, portNumber));
                Map<String, List<Channel>> map = this.serverChannels;
                synchronized (map) {
                    List<Channel> list = this.serverChannels.get(name);
                    if (list == null) {
                        list = new ArrayList<Channel>();
                        this.serverChannels.put(name, list);
                    }
                    list.add(channel);
                    boundSocket.set(this.getLocalAddress(channel));
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindTransportException("Failed to bind to [" + port + "]", (Throwable)lastException.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound profile [{}] to address {{}}", (Object)name, (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return (InetSocketAddress)boundSocket.get();
    }

    private BoundTransportAddress createBoundTransportAddress(String name, Settings profileSettings, List<InetSocketAddress> boundAddresses) {
        InetAddress publishInetAddress;
        String[] boundAddressesHostStrings = new String[boundAddresses.size()];
        TransportAddress[] transportBoundAddresses = new TransportAddress[boundAddresses.size()];
        for (int i = 0; i < boundAddresses.size(); ++i) {
            InetSocketAddress boundAddress = boundAddresses.get(i);
            boundAddressesHostStrings[i] = boundAddress.getHostString();
            transportBoundAddresses[i] = new InetSocketTransportAddress(boundAddress);
        }
        String[] publishHosts = "default".equals(name) ? TransportSettings.PUBLISH_HOST.get(this.settings).toArray(Strings.EMPTY_ARRAY) : profileSettings.getAsArray("publish_host", boundAddressesHostStrings);
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = TcpTransport.resolvePublishPort(name, this.settings, profileSettings, boundAddresses, publishInetAddress);
        InetSocketTransportAddress publishAddress = new InetSocketTransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        return new BoundTransportAddress(transportBoundAddresses, publishAddress);
    }

    public static int resolvePublishPort(String profileName, Settings settings, Settings profileSettings, List<InetSocketAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = "default".equals(profileName) ? TransportSettings.PUBLISH_PORT.get(settings).intValue() : profileSettings.getAsInt("publish_port", -1).intValue();
        if (publishPort < 0) {
            for (InetSocketAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (InetSocketAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            String profileExplanation = "default".equals(profileName) ? "" : " for profile " + profileName;
            throw new BindTransportException("Failed to auto-resolve publish port" + profileExplanation + ", multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting " + TransportSettings.PORT.getKey() + " or " + TransportSettings.PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    @Override
    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws UnknownHostException {
        return TcpTransport.parse(address, this.settings.get("transport.profiles.default.port", TransportSettings.PORT.get(this.settings)), perAddressLimit);
    }

    static TransportAddress[] parse(String hostPortString, String defaultPortRange, int perAddressLimit) throws UnknownHostException {
        String host;
        Objects.requireNonNull(hostPortString);
        String portString = null;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid bracketed host/port range: " + hostPortString);
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                if (colonPos >= 0) {
                    throw new IllegalArgumentException("IPv6 addresses must be bracketed: " + hostPortString);
                }
            }
        }
        if (portString == null || portString.isEmpty()) {
            portString = defaultPortRange;
        }
        HashSet<InetAddress> addresses = new HashSet<InetAddress>(Arrays.asList(InetAddress.getAllByName(host)));
        ArrayList<InetSocketTransportAddress> transportAddresses = new ArrayList<InetSocketTransportAddress>();
        int[] ports = new PortsRange(portString).ports();
        int limit = Math.min(ports.length, perAddressLimit);
        for (int i = 0; i < limit; ++i) {
            for (InetAddress address : addresses) {
                transportAddresses.add(new InetSocketTransportAddress(address, ports[i]));
            }
        }
        return transportAddresses.toArray(new TransportAddress[transportAddresses.size()]);
    }

    @Override
    protected final void doClose() {
    }

    @Override
    protected final void doStop() {
        CountDownLatch latch = new CountDownLatch(1);
        this.threadPool.generic().execute(() -> {
            this.globalLock.writeLock().lock();
            try {
                for (Map.Entry entry : this.serverChannels.entrySet()) {
                    try {
                        this.closeChannels(entry.getValue());
                    }
                    catch (Exception e) {
                        this.logger.debug(() -> new ParameterizedMessage("Error closing serverChannel for profile [{}]", entry.getKey()), (Throwable)e);
                    }
                }
                IOUtils.closeWhileHandlingException(Iterables.concat(this.connectedNodes.values(), this.openConnections));
                this.openConnections.clear();
                this.connectedNodes.clear();
                this.stopInternal();
            }
            finally {
                this.globalLock.writeLock().unlock();
                latch.countDown();
            }
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(Channel channel, Exception e) throws IOException {
        String reason = ExceptionsHelper.detailedMessage(e);
        if (!this.lifecycle.started()) {
            this.disconnectFromNodeChannel(channel, reason);
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e)) {
            this.logger.trace(() -> new ParameterizedMessage("close connection exception caught on transport layer [{}], disconnecting from relevant node", channel), (Throwable)e);
            this.disconnectFromNodeChannel(channel, reason);
        } else if (NetworkExceptionHelper.isConnectException(e)) {
            this.logger.trace(() -> new ParameterizedMessage("connect exception caught on transport layer [{}]", channel), (Throwable)e);
            this.disconnectFromNodeChannel(channel, reason);
        } else if (e instanceof BindException) {
            this.logger.trace(() -> new ParameterizedMessage("bind exception caught on transport layer [{}]", channel), (Throwable)e);
            this.disconnectFromNodeChannel(channel, reason);
        } else if (e instanceof CancelledKeyException) {
            this.logger.trace(() -> new ParameterizedMessage("cancelled key exception caught on transport layer [{}], disconnecting from relevant node", channel), (Throwable)e);
            this.disconnectFromNodeChannel(channel, reason);
        } else if (e instanceof HttpOnTransportException) {
            if (this.isOpen(channel)) {
                Runnable closeChannel = () -> {
                    try {
                        this.closeChannels(Collections.singletonList(channel));
                    }
                    catch (IOException e1) {
                        this.logger.debug("failed to close httpOnTransport channel", (Throwable)e1);
                    }
                };
                boolean success = false;
                try {
                    this.sendMessage(channel, new BytesArray(e.getMessage().getBytes(StandardCharsets.UTF_8)), closeChannel);
                    success = true;
                }
                finally {
                    if (!success) {
                        closeChannel.run();
                    }
                }
            }
        } else {
            this.logger.warn(() -> new ParameterizedMessage("exception caught on transport layer [{}], closing connection", channel), (Throwable)e);
            this.disconnectFromNodeChannel(channel, reason);
        }
    }

    protected abstract InetSocketAddress getLocalAddress(Channel var1);

    protected abstract Channel bind(String var1, InetSocketAddress var2) throws IOException;

    protected abstract void closeChannels(List<Channel> var1) throws IOException;

    protected abstract void sendMessage(Channel var1, BytesReference var2, Runnable var3) throws IOException;

    protected abstract NodeChannels connectToChannels(DiscoveryNode var1, ConnectionProfile var2, Consumer<Channel> var3) throws IOException;

    protected void stopInternal() {
    }

    public boolean canCompress(TransportRequest request) {
        return this.compress && !(request instanceof BytesTransportRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestToChannel(DiscoveryNode node, Channel targetChannel, long requestId, String action, TransportRequest request, TransportRequestOptions options, Version channelVersion, byte status) throws IOException, TransportException {
        if (this.compress) {
            options = TransportRequestOptions.builder(options).withCompress(true).build();
        }
        status = TransportStatus.setRequest(status);
        ReleasableBytesStreamOutput bStream = new ReleasableBytesStreamOutput(this.bigArrays);
        boolean addedReleaseListener = false;
        StreamOutput stream = Streams.flushOnCloseStream(bStream);
        try {
            if (options.compress() && this.canCompress(request)) {
                status = TransportStatus.setCompress(status);
                stream = CompressorFactory.COMPRESSOR.streamOutput(stream);
            }
            Version version = Version.min(this.getCurrentVersion(), channelVersion);
            stream.setVersion(version);
            this.threadPool.getThreadContext().writeTo(stream);
            stream.writeString(action);
            BytesReference message = this.buildMessage(requestId, status, node.getVersion(), request, stream, bStream);
            TransportRequestOptions finalOptions = options;
            StreamOutput finalStream = stream;
            Runnable onRequestSent = () -> {
                try {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{finalStream, bStream});
                }
                finally {
                    this.transportServiceAdapter.onRequestSent(node, requestId, action, request, finalOptions);
                }
            };
            addedReleaseListener = this.internalSendMessage(targetChannel, message, onRequestSent);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{stream});
            if (!addedReleaseListener) {
                IOUtils.close((Closeable[])new Closeable[]{stream, bStream});
            }
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{stream});
        if (!addedReleaseListener) {
            IOUtils.close((Closeable[])new Closeable[]{stream, bStream});
        }
    }

    private boolean internalSendMessage(Channel targetChannel, BytesReference message, Runnable onRequestSent) throws IOException {
        boolean success;
        try {
            this.sendMessage(targetChannel, message, onRequestSent);
            success = true;
        }
        catch (IOException ex) {
            this.onException(targetChannel, ex);
            success = false;
        }
        return success;
    }

    public void sendErrorResponse(Version nodeVersion, Channel channel, Exception error, long requestId, String action) throws IOException {
        try (BytesStreamOutput stream = new BytesStreamOutput();){
            stream.setVersion(nodeVersion);
            RemoteTransportException tx = new RemoteTransportException(this.nodeName(), new InetSocketTransportAddress(this.getLocalAddress(channel)), action, error);
            this.threadPool.getThreadContext().writeTo(stream);
            stream.writeException(tx);
            byte status = 0;
            status = TransportStatus.setResponse(status);
            status = TransportStatus.setError(status);
            BytesReference bytes = stream.bytes();
            BytesReference header = this.buildHeader(requestId, status, nodeVersion, bytes.length());
            Runnable onRequestSent = () -> this.transportServiceAdapter.onResponseSent(requestId, action, error);
            this.sendMessage(channel, new CompositeBytesReference(header, bytes), onRequestSent);
        }
    }

    public void sendResponse(Version nodeVersion, Channel channel, TransportResponse response, long requestId, String action, TransportResponseOptions options) throws IOException {
        this.sendResponse(nodeVersion, channel, response, requestId, action, options, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendResponse(Version nodeVersion, Channel channel, TransportResponse response, long requestId, String action, TransportResponseOptions options, byte status) throws IOException {
        void var11_12;
        if (this.compress) {
            options = TransportResponseOptions.builder(options).withCompress(true).build();
        }
        status = TransportStatus.setResponse(status);
        ReleasableBytesStreamOutput bStream = new ReleasableBytesStreamOutput(this.bigArrays);
        boolean addedReleaseListener = false;
        BytesStream bytesStream = Streams.flushOnCloseStream(bStream);
        try {
            if (options.compress()) {
                status = TransportStatus.setCompress(status);
                StreamOutput streamOutput = CompressorFactory.COMPRESSOR.streamOutput(bytesStream);
            }
            this.threadPool.getThreadContext().writeTo((StreamOutput)var11_12);
            var11_12.setVersion(nodeVersion);
            BytesReference reference = this.buildMessage(requestId, status, nodeVersion, response, (StreamOutput)var11_12, bStream);
            TransportResponseOptions finalOptions = options;
            void var14_15 = var11_12;
            Runnable onRequestSent = () -> this.lambda$sendResponse$14((StreamOutput)var14_15, bStream, requestId, action, response, finalOptions);
            addedReleaseListener = this.internalSendMessage(channel, reference, onRequestSent);
            if (addedReleaseListener) return;
        }
        catch (Throwable throwable) {
            if (addedReleaseListener) throw throwable;
            IOUtils.close((Closeable[])new Closeable[]{bytesStream, bStream});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{var11_12, bStream});
    }

    final BytesReference buildHeader(long requestId, byte status, Version protocolVersion, int length) throws IOException {
        try (BytesStreamOutput headerOutput = new BytesStreamOutput(19);){
            headerOutput.setVersion(protocolVersion);
            TcpHeader.writeHeader(headerOutput, requestId, status, protocolVersion, length);
            BytesReference bytes = headerOutput.bytes();
            assert (bytes.length() == 19) : "header size mismatch expected: 19 but was: " + bytes.length();
            BytesReference bytesReference = bytes;
            return bytesReference;
        }
    }

    private BytesReference buildMessage(long requestId, byte status, Version nodeVersion, TransportMessage message, StreamOutput stream, ReleasableBytesStreamOutput writtenBytes) throws IOException {
        BytesReference zeroCopyBuffer;
        if (message instanceof BytesTransportRequest) {
            BytesTransportRequest bRequest = (BytesTransportRequest)message;
            assert (nodeVersion.equals(bRequest.version()));
            bRequest.writeThin(stream);
            zeroCopyBuffer = bRequest.bytes;
        } else {
            message.writeTo(stream);
            zeroCopyBuffer = BytesArray.EMPTY;
        }
        stream.close();
        ReleasablePagedBytesReference messageBody = writtenBytes.bytes();
        BytesReference header = this.buildHeader(requestId, status, stream.getVersion(), ((BytesReference)messageBody).length() + zeroCopyBuffer.length());
        return new CompositeBytesReference(header, messageBody, zeroCopyBuffer);
    }

    public static boolean validateMessageHeader(BytesReference buffer) throws IOException {
        int dataLen;
        int sizeHeaderLength = 6;
        if (buffer.length() < 6) {
            throw new IllegalStateException("message size must be >= to the header size");
        }
        int offset = 0;
        if (buffer.get(offset) != 69 || buffer.get(offset + 1) != 83) {
            if (TcpTransport.bufferStartsWith(buffer, offset, "GET ") || TcpTransport.bufferStartsWith(buffer, offset, "POST ") || TcpTransport.bufferStartsWith(buffer, offset, "PUT ") || TcpTransport.bufferStartsWith(buffer, offset, "HEAD ") || TcpTransport.bufferStartsWith(buffer, offset, "DELETE ") || TcpTransport.bufferStartsWith(buffer, offset, "OPTIONS ") || TcpTransport.bufferStartsWith(buffer, offset, "PATCH ") || TcpTransport.bufferStartsWith(buffer, offset, "TRACE ")) {
                throw new HttpOnTransportException("This is not a HTTP port");
            }
            throw new StreamCorruptedException("invalid internal transport message format, got (" + Integer.toHexString(buffer.get(offset) & 0xFF) + "," + Integer.toHexString(buffer.get(offset + 1) & 0xFF) + "," + Integer.toHexString(buffer.get(offset + 2) & 0xFF) + "," + Integer.toHexString(buffer.get(offset + 3) & 0xFF) + ")");
        }
        try (StreamInput input = buffer.streamInput();){
            input.skip(2L);
            dataLen = input.readInt();
            if (dataLen == -1) {
                boolean bl = false;
                return bl;
            }
        }
        if (dataLen <= 0) {
            throw new StreamCorruptedException("invalid data length: " + dataLen);
        }
        if ((long)dataLen > NINETY_PER_HEAP_SIZE) {
            throw new IllegalArgumentException("transport content length received [" + new ByteSizeValue(dataLen) + "] exceeded [" + new ByteSizeValue(NINETY_PER_HEAP_SIZE) + "]");
        }
        if (buffer.length() < dataLen + 6) {
            throw new IllegalStateException("buffer must be >= to the message size but wasn't");
        }
        return true;
    }

    private static boolean bufferStartsWith(BytesReference buffer, int offset, String method) {
        char[] chars = method.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (buffer.get(offset + i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isOpen(Channel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageReceived(BytesReference reference, Channel channel, String profileName, InetSocketAddress remoteAddress, int messageLengthBytes) throws IOException {
        block29: {
            StreamInput streamIn;
            block28: {
                int totalMessageSize = messageLengthBytes + 2 + 4;
                this.transportServiceAdapter.addBytesReceived(totalMessageSize);
                boolean hasMessageBytesToRead = totalMessageSize - 19 > 0;
                streamIn = reference.streamInput();
                boolean success = false;
                try {
                    try (ThreadContext.StoredContext tCtx = this.threadPool.getThreadContext().stashContext();){
                        long requestId = streamIn.readLong();
                        byte status = streamIn.readByte();
                        Version version = Version.fromId(streamIn.readInt());
                        if (TransportStatus.isCompress(status) && hasMessageBytesToRead && streamIn.available() > 0) {
                            Compressor compressor;
                            try {
                                int bytesConsumed = 13;
                                compressor = CompressorFactory.compressor(reference.slice(13, reference.length() - 13));
                            }
                            catch (NotCompressedException ex) {
                                int maxToRead = Math.min(reference.length(), 10);
                                StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(reference.length()).append("] readable bytes with message size [").append(messageLengthBytes).append("] ").append("] are [");
                                for (int i = 0; i < maxToRead; ++i) {
                                    sb.append(reference.get(i)).append(",");
                                }
                                sb.append("]");
                                throw new IllegalStateException(sb.toString());
                            }
                            streamIn = compressor.streamInput(streamIn);
                        }
                        if (!version.onOrAfter(Version.CURRENT.minimumCompatibilityVersion()) || version.major != Version.CURRENT.major) {
                            throw new IllegalStateException("Received message from unsupported version: [" + version + "] minimal compatible version is: [" + Version.CURRENT.minimumCompatibilityVersion() + "]");
                        }
                        streamIn = new NamedWriteableAwareStreamInput(streamIn, this.namedWriteableRegistry);
                        streamIn.setVersion(version);
                        this.threadPool.getThreadContext().readHeaders(streamIn);
                        if (TransportStatus.isRequest(status)) {
                            this.handleRequest(channel, profileName, streamIn, requestId, messageLengthBytes, version, remoteAddress, status);
                        } else {
                            TransportResponseHandler theHandler;
                            TransportResponseHandler handler = TransportStatus.isHandshake(status) ? (TransportResponseHandler)this.pendingHandshakes.remove(requestId) : ((theHandler = this.transportServiceAdapter.onResponseReceived(requestId)) == null && TransportStatus.isError(status) ? (TransportResponseHandler)this.pendingHandshakes.remove(requestId) : theHandler);
                            if (handler != null) {
                                if (TransportStatus.isError(status)) {
                                    this.handlerResponseError(streamIn, handler);
                                } else {
                                    this.handleResponse(remoteAddress, streamIn, handler);
                                }
                                int nextByte = streamIn.read();
                                if (nextByte != -1) {
                                    throw new IllegalStateException("Message not fully read (response) for requestId [" + requestId + "], handler [" + handler + "], error [" + TransportStatus.isError(status) + "]; resetting");
                                }
                            }
                        }
                        success = true;
                    }
                    if (!success) break block28;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{streamIn});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamIn});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{streamIn});
                break block29;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamIn});
        }
    }

    private void handleResponse(InetSocketAddress remoteAddress, StreamInput stream, final TransportResponseHandler handler) {
        Object response = handler.newInstance();
        ((TransportMessage)response).remoteAddress(new InetSocketTransportAddress(remoteAddress));
        try {
            ((TransportMessage)response).readFrom(stream);
        }
        catch (Exception e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response of type [" + response.getClass().getName() + "]", e));
            return;
        }
        this.threadPool.executor(handler.executor()).execute(new AbstractRunnable((TransportResponse)response){
            final /* synthetic */ TransportResponse val$response;
            {
                this.val$response = transportResponse;
            }

            @Override
            public void onFailure(Exception e) {
                TcpTransport.this.handleException(handler, new ResponseHandlerFailureTransportException(e));
            }

            @Override
            protected void doRun() throws Exception {
                handler.handleResponse(this.val$response);
            }
        });
    }

    private void handlerResponseError(StreamInput stream, TransportResponseHandler handler) {
        Object error;
        try {
            error = stream.readException();
        }
        catch (Exception e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, (Throwable)error);
    }

    private void handleException(TransportResponseHandler handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException(error.getMessage(), error);
        }
        RemoteTransportException rtx = (RemoteTransportException)error;
        this.threadPool.executor(handler.executor()).execute(() -> {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to handle exception response [{}]", (Object)handler), (Throwable)e);
            }
        });
    }

    protected String handleRequest(Channel channel, String profileName, StreamInput stream, long requestId, int messageLengthBytes, Version version, InetSocketAddress remoteAddress, byte status) throws IOException {
        String action = stream.readString();
        this.transportServiceAdapter.onRequestReceived(requestId, action);
        TcpTransportChannel<Channel> transportChannel = null;
        try {
            if (TransportStatus.isHandshake(status)) {
                VersionHandshakeResponse response = new VersionHandshakeResponse(this.getCurrentVersion());
                this.sendResponse(version, channel, response, requestId, HANDSHAKE_ACTION_NAME, TransportResponseOptions.EMPTY, TransportStatus.setHandshake((byte)0));
            } else {
                RequestHandlerRegistry reg = this.transportServiceAdapter.getRequestHandler(action);
                if (reg == null) {
                    throw new ActionNotFoundTransportException(action);
                }
                if (reg.canTripCircuitBreaker()) {
                    this.getInFlightRequestBreaker().addEstimateBytesAndMaybeBreak(messageLengthBytes, "<transport_request>");
                } else {
                    this.getInFlightRequestBreaker().addWithoutBreaking(messageLengthBytes);
                }
                transportChannel = new TcpTransportChannel<Channel>(this, channel, this.transportName, action, requestId, version, profileName, messageLengthBytes);
                Object request = reg.newRequest();
                ((TransportMessage)request).remoteAddress(new InetSocketTransportAddress(remoteAddress));
                ((TransportRequest)request).readFrom(stream);
                this.validateRequest(stream, requestId, action);
                this.threadPool.executor(reg.getExecutor()).execute(new RequestHandler(reg, (TransportRequest)request, transportChannel));
            }
        }
        catch (Exception e) {
            if (transportChannel == null) {
                transportChannel = new TcpTransportChannel<Channel>(this, channel, this.transportName, action, requestId, version, profileName, 0L);
            }
            try {
                transportChannel.sendResponse(e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                this.logger.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)action), (Throwable)inner);
            }
        }
        return action;
    }

    protected void validateRequest(StreamInput stream, long requestId, String action) throws IOException {
        int nextByte = stream.read();
        if (nextByte != -1) {
            throw new IllegalStateException("Message not fully read (request) for requestId [" + requestId + "], action [" + action + "], available [" + stream.available() + "]; resetting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version executeHandshake(DiscoveryNode node, Channel channel, TimeValue timeout) throws IOException, InterruptedException {
        this.numHandshakes.inc();
        long requestId = this.newRequestId();
        HandshakeResponseHandler<Channel> handler = new HandshakeResponseHandler<Channel>(channel);
        AtomicReference<Version> versionRef = handler.versionRef;
        AtomicReference<Exception> exceptionRef = handler.exceptionRef;
        this.pendingHandshakes.put(requestId, handler);
        boolean success = false;
        try {
            if (!this.isOpen(channel)) {
                throw new IllegalStateException("handshake failed, channel already closed");
            }
            Version minCompatVersion = this.getCurrentVersion().minimumCompatibilityVersion();
            this.sendRequestToChannel(node, channel, requestId, HANDSHAKE_ACTION_NAME, TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, minCompatVersion, TransportStatus.setHandshake((byte)0));
            if (!handler.latch.await(timeout.millis(), TimeUnit.MILLISECONDS)) {
                throw new ConnectTransportException(node, "handshake_timeout[" + timeout + "]");
            }
            success = true;
            if (handler.handshakeNotSupported.get()) {
                Version version = null;
                return version;
            }
            if (exceptionRef.get() != null) {
                throw new IllegalStateException("handshake failed", exceptionRef.get());
            }
            Version version = versionRef.get();
            if (!this.getCurrentVersion().isCompatible(version)) {
                throw new IllegalStateException("Received message from unsupported version: [" + version + "] minimal compatible version is: [" + this.getCurrentVersion().minimumCompatibilityVersion() + "]");
            }
            Version version2 = version;
            return version2;
        }
        finally {
            TransportResponseHandler removedHandler = (TransportResponseHandler)this.pendingHandshakes.remove(requestId);
            assert (success && removedHandler == null || !success) : "handler for requestId [" + requestId + "] is not been removed";
        }
    }

    final int getNumPendingHandshakes() {
        return this.pendingHandshakes.size();
    }

    final long getNumHandshakes() {
        return this.numHandshakes.count();
    }

    @Override
    public long newRequestId() {
        return this.requestIdGenerator.incrementAndGet();
    }

    private void onChannelClosed(Channel channel) {
        Long requestId;
        HandshakeResponseHandler handler;
        Optional<Long> first = this.pendingHandshakes.entrySet().stream().filter(entry -> ((HandshakeResponseHandler)entry.getValue()).channel == channel).map(e -> (Long)e.getKey()).findFirst();
        if (first.isPresent() && (handler = (HandshakeResponseHandler)this.pendingHandshakes.remove(requestId = first.get())) != null) {
            handler.handleException(new TransportException("connection reset"));
        }
    }

    protected final void ensureOpen() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("transport has been stopped");
        }
    }

    private void onNodeChannelsClosed(NodeChannels channels) {
        boolean remove = this.openConnections.remove(channels);
        if (remove) {
            this.transportServiceAdapter.onConnectionClosed(channels);
        }
    }

    final int getNumOpenConnections() {
        return this.openConnections.size();
    }

    final int getNumConnectedNodes() {
        return this.connectedNodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$sendResponse$14(StreamOutput finalStream, ReleasableBytesStreamOutput bStream, long requestId, String action, TransportResponse response, TransportResponseOptions finalOptions) {
        try {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{finalStream, bStream});
        }
        finally {
            this.transportServiceAdapter.onResponseSent(requestId, action, response, finalOptions);
        }
    }

    private /* synthetic */ void lambda$openConnection$1(AtomicBoolean runOnce, Object c) {
        try {
            this.onChannelClosed(c);
        }
        finally {
            if (runOnce.compareAndSet(false, true)) {
                this.disconnectFromNodeChannel(c, "channel closed");
            }
        }
    }

    private static final class VersionHandshakeResponse
    extends TransportResponse {
        private Version version;

        private VersionHandshakeResponse(Version version) {
            this.version = version;
        }

        private VersionHandshakeResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.version = Version.readVersion(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            assert (this.version != null);
            Version.writeVersion(this.version, out);
        }
    }

    class RequestHandler
    extends AbstractRunnable {
        private final RequestHandlerRegistry reg;
        private final TransportRequest request;
        private final TransportChannel transportChannel;

        RequestHandler(RequestHandlerRegistry reg, TransportRequest request, TransportChannel transportChannel) {
            this.reg = reg;
            this.request = request;
            this.transportChannel = transportChannel;
        }

        @Override
        protected void doRun() throws Exception {
            this.reg.processMessageReceived(this.request, this.transportChannel);
        }

        @Override
        public boolean isForceExecution() {
            return this.reg.isForceExecution();
        }

        @Override
        public void onFailure(Exception e) {
            if (TcpTransport.this.lifecycleState() == Lifecycle.State.STARTED) {
                try {
                    this.transportChannel.sendResponse(e);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    TcpTransport.this.logger.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)this.reg.getAction()), (Throwable)inner);
                }
            }
        }
    }

    public static class HttpOnTransportException
    extends ElasticsearchException {
        public HttpOnTransportException(String msg) {
            super(msg, new Object[0]);
        }

        @Override
        public RestStatus status() {
            return RestStatus.BAD_REQUEST;
        }

        public HttpOnTransportException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public final class NodeChannels
    implements Transport.Connection {
        private final Map<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle> typeMapping;
        private final Channel[] channels;
        private final DiscoveryNode node;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Version version;

        public NodeChannels(DiscoveryNode node, Channel[] channels, ConnectionProfile connectionProfile) {
            this.node = node;
            this.channels = channels;
            assert (channels.length == connectionProfile.getNumConnections()) : "expected channels size to be == " + connectionProfile.getNumConnections() + " but was: [" + channels.length + "]";
            this.typeMapping = new EnumMap<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle>(TransportRequestOptions.Type.class);
            for (ConnectionProfile.ConnectionTypeHandle handle : connectionProfile.getHandles()) {
                for (TransportRequestOptions.Type type : handle.getTypes()) {
                    this.typeMapping.put(type, handle);
                }
            }
            this.version = node.getVersion();
        }

        NodeChannels(NodeChannels channels, Version handshakeVersion) {
            this.node = channels.node;
            this.channels = channels.channels;
            this.typeMapping = channels.typeMapping;
            this.version = handshakeVersion;
            assert (handshakeVersion != null) : "handshakeVersion must not be null";
        }

        @Override
        public Version getVersion() {
            return this.version;
        }

        public boolean hasChannel(Channel channel) {
            for (Object channel1 : this.channels) {
                if (!channel.equals(channel1)) continue;
                return true;
            }
            return false;
        }

        public List<Channel> getChannels() {
            return Arrays.asList(this.channels);
        }

        public Channel channel(TransportRequestOptions.Type type) {
            ConnectionProfile.ConnectionTypeHandle connectionTypeHandle = this.typeMapping.get((Object)type);
            if (connectionTypeHandle == null) {
                throw new IllegalArgumentException("no type channel for [" + (Object)((Object)type) + "]");
            }
            return connectionTypeHandle.getChannel(this.channels);
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                try {
                    TcpTransport.this.closeChannels(Arrays.stream(this.channels).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                finally {
                    TcpTransport.this.onNodeChannelsClosed(this);
                }
            }
        }

        @Override
        public DiscoveryNode getNode() {
            return this.node;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            if (this.closed.get()) {
                throw new NodeNotConnectedException(this.node, "connection already closed");
            }
            Object channel = this.channel(options.type());
            TcpTransport.this.sendRequestToChannel(this.node, channel, requestId, action, request, options, this.getVersion(), (byte)0);
        }
    }

    public class ScheduledPing
    extends AbstractLifecycleRunnable {
        private final BytesReference pingHeader;
        final CounterMetric successfulPings;
        final CounterMetric failedPings;

        public ScheduledPing() {
            super(TcpTransport.this.lifecycle, TcpTransport.this.logger);
            this.successfulPings = new CounterMetric();
            this.failedPings = new CounterMetric();
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.writeByte((byte)69);
                out.writeByte((byte)83);
                out.writeInt(-1);
                this.pingHeader = out.bytes();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        protected void doRunInLifecycle() throws Exception {
            for (Map.Entry entry : TcpTransport.this.connectedNodes.entrySet()) {
                DiscoveryNode node = (DiscoveryNode)entry.getKey();
                NodeChannels channels = (NodeChannels)entry.getValue();
                for (Object channel : channels.getChannels()) {
                    try {
                        TcpTransport.this.sendMessage(channel, this.pingHeader, this.successfulPings::inc);
                    }
                    catch (Exception e) {
                        if (TcpTransport.this.isOpen(channel)) {
                            TcpTransport.this.logger.debug(() -> new ParameterizedMessage("[{}] failed to send ping transport message", (Object)node), (Throwable)e);
                            this.failedPings.inc();
                            continue;
                        }
                        TcpTransport.this.logger.trace(() -> new ParameterizedMessage("[{}] failed to send ping transport message (channel closed)", (Object)node), (Throwable)e);
                    }
                }
            }
        }

        public long getSuccessfulPings() {
            return this.successfulPings.count();
        }

        public long getFailedPings() {
            return this.failedPings.count();
        }

        @Override
        protected void onAfterInLifecycle() {
            try {
                TcpTransport.this.threadPool.schedule(TcpTransport.this.pingSchedule, "generic", this);
            }
            catch (EsRejectedExecutionException ex) {
                if (ex.isExecutorShutdown()) {
                    TcpTransport.this.logger.debug("couldn't schedule new ping execution, executor is shutting down", (Throwable)ex);
                }
                throw ex;
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (TcpTransport.this.lifecycle.stoppedOrClosed()) {
                TcpTransport.this.logger.trace("failed to send ping transport message", (Throwable)e);
            } else {
                TcpTransport.this.logger.warn("failed to send ping transport message", (Throwable)e);
            }
        }
    }

    private static class HandshakeResponseHandler<Channel>
    implements TransportResponseHandler<VersionHandshakeResponse> {
        final AtomicReference<Version> versionRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean handshakeNotSupported = new AtomicBoolean(false);
        final AtomicReference<Exception> exceptionRef = new AtomicReference();
        final Channel channel;

        HandshakeResponseHandler(Channel channel) {
            this.channel = channel;
        }

        @Override
        public VersionHandshakeResponse newInstance() {
            return new VersionHandshakeResponse();
        }

        @Override
        public void handleResponse(VersionHandshakeResponse response) {
            boolean success = this.versionRef.compareAndSet(null, response.version);
            assert (success);
            this.latch.countDown();
        }

        @Override
        public void handleException(TransportException exp) {
            Throwable cause = exp.getCause();
            if (cause != null && cause instanceof ActionNotFoundTransportException && cause.getMessage().equals("No handler for action [internal:tcp/handshake]")) {
                this.handshakeNotSupported.set(true);
            } else {
                boolean success = this.exceptionRef.compareAndSet(null, exp);
                assert (success);
            }
            this.latch.countDown();
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

