/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.http.CorsHandler;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.HttpTracer;
import org.elasticsearch.http.HttpUtils;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class DefaultRestChannel
extends AbstractRestChannel
implements RestChannel {
    static final String CLOSE = "close";
    static final String CONNECTION = "connection";
    static final String KEEP_ALIVE = "keep-alive";
    static final String CONTENT_TYPE = "content-type";
    static final String CONTENT_LENGTH = "content-length";
    static final String SET_COOKIE = "set-cookie";
    private final HttpRequest httpRequest;
    private final BigArrays bigArrays;
    private final HttpHandlingSettings settings;
    private final ThreadContext threadContext;
    private final HttpChannel httpChannel;
    private final CorsHandler corsHandler;
    @Nullable
    private final HttpTracer tracerLog;

    DefaultRestChannel(HttpChannel httpChannel, HttpRequest httpRequest, RestRequest request, BigArrays bigArrays, HttpHandlingSettings settings, ThreadContext threadContext, CorsHandler corsHandler, @Nullable HttpTracer tracerLog) {
        super(request, settings.getDetailedErrorsEnabled());
        this.httpChannel = httpChannel;
        this.httpRequest = httpRequest;
        this.bigArrays = bigArrays;
        this.settings = settings;
        this.threadContext = threadContext;
        this.corsHandler = corsHandler;
        this.tracerLog = tracerLog;
    }

    @Override
    protected BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(RestResponse restResponse) {
        String contentLength;
        String opaque;
        boolean success;
        block19: {
            this.httpRequest.release();
            ArrayList<Releasable> toClose = new ArrayList<Releasable>(3);
            if (HttpUtils.shouldCloseConnection(this.httpRequest)) {
                toClose.add(() -> CloseableChannel.closeChannel(this.httpChannel));
            }
            success = false;
            opaque = null;
            contentLength = null;
            try {
                BytesReference finalContent;
                block17: {
                    BytesReference content = restResponse.content();
                    if (content instanceof Releasable) {
                        toClose.add((Releasable)content);
                    }
                    toClose.add(this::releaseOutputBuffer);
                    finalContent = content;
                    try {
                        if (this.request.method() == RestRequest.Method.HEAD) {
                            finalContent = BytesArray.EMPTY;
                        }
                    }
                    catch (IllegalArgumentException ignored) {
                        if ($assertionsDisabled || restResponse.status() == RestStatus.METHOD_NOT_ALLOWED) break block17;
                        throw new AssertionError((Object)"request HTTP method is unsupported but HTTP status is not METHOD_NOT_ALLOWED(405)");
                    }
                }
                HttpResponse httpResponse = this.httpRequest.createResponse(restResponse.status(), finalContent);
                this.corsHandler.setCorsResponseHeaders(this.httpRequest, httpResponse);
                opaque = this.request.header("X-Opaque-Id");
                if (opaque != null) {
                    this.setHeaderField(httpResponse, "X-Opaque-Id", opaque);
                }
                this.addCustomHeaders(httpResponse, restResponse.getHeaders());
                this.addCustomHeaders(httpResponse, restResponse.filterHeaders(this.threadContext.getResponseHeaders()));
                this.setHeaderField(httpResponse, CONTENT_TYPE, restResponse.contentType(), false);
                contentLength = String.valueOf(restResponse.content().length());
                this.setHeaderField(httpResponse, CONTENT_LENGTH, contentLength, false);
                this.addCookies(httpResponse);
                ActionListener<Void> listener = ActionListener.wrap(() -> Releasables.close((Iterable)toClose));
                try (ThreadContext.StoredContext existing = this.threadContext.stashContext();){
                    this.httpChannel.sendResponse(httpResponse, listener);
                }
                success = true;
                if (success) break block19;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close(toClose);
                }
                if (this.tracerLog != null) {
                    this.tracerLog.traceResponse(restResponse, this.httpChannel, contentLength, opaque, this.request.getRequestId(), success);
                }
                throw throwable;
            }
            Releasables.close(toClose);
        }
        if (this.tracerLog != null) {
            this.tracerLog.traceResponse(restResponse, this.httpChannel, contentLength, opaque, this.request.getRequestId(), success);
        }
    }

    private void setHeaderField(HttpResponse response, String headerField, String value) {
        this.setHeaderField(response, headerField, value, true);
    }

    private void setHeaderField(HttpResponse response, String headerField, String value, boolean override) {
        if (override || !response.containsHeader(headerField)) {
            response.addHeader(headerField, value);
        }
    }

    private void addCustomHeaders(HttpResponse response, Map<String, List<String>> customHeaders) {
        if (customHeaders != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    this.setHeaderField(response, headerEntry.getKey(), headerValue);
                }
            }
        }
    }

    private void addCookies(HttpResponse response) {
        List<String> cookies;
        if (this.settings.isResetCookies() && !(cookies = this.request.getHttpRequest().strictCookies()).isEmpty()) {
            for (String cookie : cookies) {
                response.addHeader(SET_COOKIE, cookie);
            }
        }
    }
}

