/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.IOParameter;

public class OutParameterParser
extends BaseChildElementParser {
    public static final List<ExtensionAttribute> defaultOutParameterAttributes = Arrays.asList(new ExtensionAttribute("source"), new ExtensionAttribute("sourceExpression"), new ExtensionAttribute("transient"), new ExtensionAttribute("target"));

    @Override
    public String getElementName() {
        return "out";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        String source = xtr.getAttributeValue(null, "source");
        String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
        String target = xtr.getAttributeValue(null, "target");
        if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
            IOParameter parameter = new IOParameter();
            if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                parameter.setSourceExpression(sourceExpression);
            } else {
                parameter.setSource(source);
            }
            parameter.setTarget(target);
            String transientValue = xtr.getAttributeValue(null, "transient");
            if ("true".equalsIgnoreCase(transientValue)) {
                parameter.setTransient(true);
            }
            BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)parameter, defaultOutParameterAttributes);
            if (parentElement instanceof CallActivity) {
                CallActivity callActivity = (CallActivity)parentElement;
                callActivity.getOutParameters().add(parameter);
            } else if (parentElement instanceof CaseServiceTask) {
                ((CaseServiceTask)parentElement).getOutParameters().add(parameter);
            } else if (parentElement instanceof Event) {
                ((Event)parentElement).getOutParameters().add(parameter);
            }
        } else if (parentElement instanceof CallActivity) {
            CallActivity callActivity = (CallActivity)parentElement;
            String variables = xtr.getAttributeValue(null, "variables");
            if ("all".equalsIgnoreCase(variables)) {
                callActivity.addAttribute(new ExtensionAttribute("variables", "all"));
                String local = xtr.getAttributeValue(null, "local");
                if ("true".equalsIgnoreCase(local)) {
                    callActivity.addAttribute(new ExtensionAttribute("allOutVariableslocal", "true"));
                }
            }
        }
    }
}

