/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.InternalTaskLocalizationManager;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class DefaultTaskLocalizationManager
implements InternalTaskLocalizationManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultTaskLocalizationManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public void localize(Task task, String locale, boolean withLocalizationFallback) {
        ObjectNode languageNode;
        String processDefinitionId;
        task.setLocalizedName(null);
        task.setLocalizedDescription(null);
        if (locale != null && (processDefinitionId = task.getProcessDefinitionId()) != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(locale, task.getTaskDefinitionKey(), processDefinitionId, withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                task.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                task.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }

    public void localize(HistoricTaskInstance task, String locale, boolean withLocalizationFallback) {
        ObjectNode languageNode;
        String processDefinitionId;
        HistoricTaskInstanceEntity taskEntity = (HistoricTaskInstanceEntity)task;
        taskEntity.setLocalizedName(null);
        taskEntity.setLocalizedDescription(null);
        if (locale != null && (processDefinitionId = task.getProcessDefinitionId()) != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(locale, task.getTaskDefinitionKey(), processDefinitionId, withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                taskEntity.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                taskEntity.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return this.processEngineConfiguration.getExecutionEntityManager();
    }
}

