/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayEntityManager;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.AttachmentEntity;
import org.flowable.engine.impl.persistence.entity.AttachmentEntityManager;
import org.flowable.engine.impl.persistence.entity.data.AttachmentDataManager;
import org.flowable.engine.task.Attachment;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class AttachmentEntityManagerImpl
extends AbstractProcessEngineEntityManager<AttachmentEntity, AttachmentDataManager>
implements AttachmentEntityManager {
    public AttachmentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, AttachmentDataManager attachmentDataManager) {
        super(processEngineConfiguration, attachmentDataManager);
    }

    @Override
    public List<AttachmentEntity> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return ((AttachmentDataManager)this.dataManager).findAttachmentsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<AttachmentEntity> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return ((AttachmentDataManager)this.dataManager).findAttachmentsByTaskId(taskId);
    }

    @Override
    public void deleteAttachmentsByTaskId(String taskId) {
        TaskEntity task;
        this.checkHistoryEnabled();
        List<AttachmentEntity> attachments = this.findAttachmentsByTaskId(taskId);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        boolean dispatchEvents = eventDispatcher != null && eventDispatcher.isEnabled();
        String processInstanceId = null;
        String processDefinitionId = null;
        String executionId = null;
        if (dispatchEvents && attachments != null && !attachments.isEmpty() && (task = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getTaskServiceConfiguration().getTaskService().getTask(taskId)) != null) {
            processDefinitionId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            executionId = task.getExecutionId();
        }
        for (Attachment attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayEntityManager().deleteByteArrayById(contentId);
            }
            ((AttachmentDataManager)this.dataManager).delete((AttachmentEntity)attachment);
            if (!dispatchEvents) continue;
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, attachment, executionId, processInstanceId, processDefinitionId), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new FlowableException("In order to use attachments, history should be enabled");
        }
    }

    protected HistoryManager getHistoryManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getHistoryManager();
    }

    protected ByteArrayEntityManager getByteArrayEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getByteArrayEntityManager();
    }
}

