/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.ServicesEntry;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.writer.ModelWriter;

public class MapperServiceProcessor
implements ModelElementProcessor<Mapper, Void> {
    @Override
    public Void process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        boolean spiGenerationNeeded;
        if (context.getOptions().isAlwaysGenerateSpi()) {
            spiGenerationNeeded = true;
        } else {
            String componentModel = MapperOptions.getInstanceOn(mapperTypeElement, context.getOptions()).componentModel();
            spiGenerationNeeded = "default".equals(componentModel);
        }
        if (!context.isErroneous() && spiGenerationNeeded && mapper.hasCustomImplementation()) {
            this.writeToSourceFile(context.getFiler(), mapper);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 10000;
    }

    private void writeToSourceFile(Filer filer, Mapper model) {
        ModelWriter modelWriter = new ModelWriter();
        ServicesEntry servicesEntry = this.getServicesEntry(model);
        this.createSourceFile(servicesEntry, modelWriter, filer);
    }

    private ServicesEntry getServicesEntry(Mapper mapper) {
        if (mapper.getDecorator() != null) {
            return this.getServicesEntry(mapper.getDecorator());
        }
        return this.getServicesEntry(mapper.getMapperDefinitionType(), mapper);
    }

    private ServicesEntry getServicesEntry(Decorator decorator) {
        return this.getServicesEntry(decorator.getMapperType(), decorator);
    }

    private ServicesEntry getServicesEntry(Type mapperType, GeneratedType model) {
        String mapperName = mapperType.getName();
        String mapperPackageName = mapperType.getPackageName();
        return new ServicesEntry(mapperPackageName, mapperName, model.getPackageName(), model.getName());
    }

    private void createSourceFile(ServicesEntry model, ModelWriter modelWriter, Filer filer) {
        FileObject sourceFile;
        String fileName = model.getPackageName() + "." + model.getName();
        try {
            sourceFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + fileName, new Element[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        modelWriter.writeModel(sourceFile, model);
    }
}

