/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.PropertyAccessor;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

public class DynamicContext {
    public static final String PARAMETER_OBJECT_KEY = "_parameter";
    public static final String DATABASE_ID_KEY = "_databaseId";
    private final ContextMap bindings;
    private final StringBuilder sqlBuilder = new StringBuilder();
    private int uniqueNumber = 0;

    public DynamicContext(Configuration configuration, Object parameterObject) {
        if (parameterObject != null && !(parameterObject instanceof Map)) {
            MetaObject metaObject = configuration.newMetaObject(parameterObject);
            this.bindings = new ContextMap(metaObject);
        } else {
            this.bindings = new ContextMap(null);
        }
        this.bindings.put(PARAMETER_OBJECT_KEY, parameterObject);
        this.bindings.put(DATABASE_ID_KEY, configuration.getDatabaseId());
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public void bind(String name, Object value) {
        this.bindings.put(name, value);
    }

    public void appendSql(String sql) {
        this.sqlBuilder.append(sql);
        this.sqlBuilder.append(" ");
    }

    public String getSql() {
        return this.sqlBuilder.toString().trim();
    }

    public int getUniqueNumber() {
        return this.uniqueNumber++;
    }

    static {
        OgnlRuntime.setPropertyAccessor(ContextMap.class, new ContextAccessor());
    }

    static class ContextAccessor
    implements PropertyAccessor {
        ContextAccessor() {
        }

        @Override
        public Object getProperty(Map context, Object target, Object name) {
            Map map = (Map)target;
            Object result = map.get(name);
            if (map.containsKey(name) || result != null) {
                return result;
            }
            Object parameterObject = map.get(DynamicContext.PARAMETER_OBJECT_KEY);
            if (parameterObject instanceof Map) {
                return ((Map)parameterObject).get(name);
            }
            return null;
        }

        @Override
        public void setProperty(Map context, Object target, Object name, Object value) {
            Map map = (Map)target;
            map.put(name, value);
        }

        @Override
        public String getSourceAccessor(OgnlContext arg0, Object arg1, Object arg2) {
            return null;
        }

        @Override
        public String getSourceSetter(OgnlContext arg0, Object arg1, Object arg2) {
            return null;
        }
    }

    static class ContextMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 2977601501966151582L;
        private MetaObject parameterMetaObject;

        public ContextMap(MetaObject parameterMetaObject) {
            this.parameterMetaObject = parameterMetaObject;
        }

        @Override
        public Object get(Object key) {
            String strKey = (String)key;
            if (super.containsKey(strKey)) {
                return super.get(strKey);
            }
            if (this.parameterMetaObject != null) {
                return this.parameterMetaObject.getValue(strKey);
            }
            return null;
        }
    }
}

