/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.smartboot.http.common.codec.h2.hpack.HPACK;
import org.smartboot.http.common.codec.h2.hpack.Huffman;

public final class QuickHuffman {
    private static final long[] codes = new long[256];
    private static final int EOS_LENGTH = 30;
    private static final int EOS_LSB = 0x3FFFFFFF;
    private static final long EOS_MSB = -17179869184L;
    private static final Node root = QuickHuffman.buildTrie();

    private static long codeValueOf(char c) {
        return codes[c] & 0xFFFFFFFF00000000L;
    }

    private static long codeLengthOf(char c) {
        return codes[c] & 0xFFFFFFFFL;
    }

    private static Node buildTrie() {
        TemporaryNode tmpRoot = new TemporaryNode();
        QuickHuffman.addChar(tmpRoot, 0, 8184, 13);
        QuickHuffman.addChar(tmpRoot, 1, 8388568, 23);
        QuickHuffman.addChar(tmpRoot, 2, 0xFFFFFE2, 28);
        QuickHuffman.addChar(tmpRoot, 3, 0xFFFFFE3, 28);
        QuickHuffman.addChar(tmpRoot, 4, 0xFFFFFE4, 28);
        QuickHuffman.addChar(tmpRoot, 5, 0xFFFFFE5, 28);
        QuickHuffman.addChar(tmpRoot, 6, 0xFFFFFE6, 28);
        QuickHuffman.addChar(tmpRoot, 7, 0xFFFFFE7, 28);
        QuickHuffman.addChar(tmpRoot, 8, 0xFFFFFE8, 28);
        QuickHuffman.addChar(tmpRoot, 9, 0xFFFFEA, 24);
        QuickHuffman.addChar(tmpRoot, 10, 0x3FFFFFFC, 30);
        QuickHuffman.addChar(tmpRoot, 11, 0xFFFFFE9, 28);
        QuickHuffman.addChar(tmpRoot, 12, 0xFFFFFEA, 28);
        QuickHuffman.addChar(tmpRoot, 13, 0x3FFFFFFD, 30);
        QuickHuffman.addChar(tmpRoot, 14, 0xFFFFFEB, 28);
        QuickHuffman.addChar(tmpRoot, 15, 0xFFFFFEC, 28);
        QuickHuffman.addChar(tmpRoot, 16, 0xFFFFFED, 28);
        QuickHuffman.addChar(tmpRoot, 17, 0xFFFFFEE, 28);
        QuickHuffman.addChar(tmpRoot, 18, 0xFFFFFEF, 28);
        QuickHuffman.addChar(tmpRoot, 19, 0xFFFFFF0, 28);
        QuickHuffman.addChar(tmpRoot, 20, 0xFFFFFF1, 28);
        QuickHuffman.addChar(tmpRoot, 21, 0xFFFFFF2, 28);
        QuickHuffman.addChar(tmpRoot, 22, 0x3FFFFFFE, 30);
        QuickHuffman.addChar(tmpRoot, 23, 0xFFFFFF3, 28);
        QuickHuffman.addChar(tmpRoot, 24, 0xFFFFFF4, 28);
        QuickHuffman.addChar(tmpRoot, 25, 0xFFFFFF5, 28);
        QuickHuffman.addChar(tmpRoot, 26, 0xFFFFFF6, 28);
        QuickHuffman.addChar(tmpRoot, 27, 0xFFFFFF7, 28);
        QuickHuffman.addChar(tmpRoot, 28, 0xFFFFFF8, 28);
        QuickHuffman.addChar(tmpRoot, 29, 0xFFFFFF9, 28);
        QuickHuffman.addChar(tmpRoot, 30, 0xFFFFFFA, 28);
        QuickHuffman.addChar(tmpRoot, 31, 0xFFFFFFB, 28);
        QuickHuffman.addChar(tmpRoot, 32, 20, 6);
        QuickHuffman.addChar(tmpRoot, 33, 1016, 10);
        QuickHuffman.addChar(tmpRoot, 34, 1017, 10);
        QuickHuffman.addChar(tmpRoot, 35, 4090, 12);
        QuickHuffman.addChar(tmpRoot, 36, 8185, 13);
        QuickHuffman.addChar(tmpRoot, 37, 21, 6);
        QuickHuffman.addChar(tmpRoot, 38, 248, 8);
        QuickHuffman.addChar(tmpRoot, 39, 2042, 11);
        QuickHuffman.addChar(tmpRoot, 40, 1018, 10);
        QuickHuffman.addChar(tmpRoot, 41, 1019, 10);
        QuickHuffman.addChar(tmpRoot, 42, 249, 8);
        QuickHuffman.addChar(tmpRoot, 43, 2043, 11);
        QuickHuffman.addChar(tmpRoot, 44, 250, 8);
        QuickHuffman.addChar(tmpRoot, 45, 22, 6);
        QuickHuffman.addChar(tmpRoot, 46, 23, 6);
        QuickHuffman.addChar(tmpRoot, 47, 24, 6);
        QuickHuffman.addChar(tmpRoot, 48, 0, 5);
        QuickHuffman.addChar(tmpRoot, 49, 1, 5);
        QuickHuffman.addChar(tmpRoot, 50, 2, 5);
        QuickHuffman.addChar(tmpRoot, 51, 25, 6);
        QuickHuffman.addChar(tmpRoot, 52, 26, 6);
        QuickHuffman.addChar(tmpRoot, 53, 27, 6);
        QuickHuffman.addChar(tmpRoot, 54, 28, 6);
        QuickHuffman.addChar(tmpRoot, 55, 29, 6);
        QuickHuffman.addChar(tmpRoot, 56, 30, 6);
        QuickHuffman.addChar(tmpRoot, 57, 31, 6);
        QuickHuffman.addChar(tmpRoot, 58, 92, 7);
        QuickHuffman.addChar(tmpRoot, 59, 251, 8);
        QuickHuffman.addChar(tmpRoot, 60, 32764, 15);
        QuickHuffman.addChar(tmpRoot, 61, 32, 6);
        QuickHuffman.addChar(tmpRoot, 62, 4091, 12);
        QuickHuffman.addChar(tmpRoot, 63, 1020, 10);
        QuickHuffman.addChar(tmpRoot, 64, 8186, 13);
        QuickHuffman.addChar(tmpRoot, 65, 33, 6);
        QuickHuffman.addChar(tmpRoot, 66, 93, 7);
        QuickHuffman.addChar(tmpRoot, 67, 94, 7);
        QuickHuffman.addChar(tmpRoot, 68, 95, 7);
        QuickHuffman.addChar(tmpRoot, 69, 96, 7);
        QuickHuffman.addChar(tmpRoot, 70, 97, 7);
        QuickHuffman.addChar(tmpRoot, 71, 98, 7);
        QuickHuffman.addChar(tmpRoot, 72, 99, 7);
        QuickHuffman.addChar(tmpRoot, 73, 100, 7);
        QuickHuffman.addChar(tmpRoot, 74, 101, 7);
        QuickHuffman.addChar(tmpRoot, 75, 102, 7);
        QuickHuffman.addChar(tmpRoot, 76, 103, 7);
        QuickHuffman.addChar(tmpRoot, 77, 104, 7);
        QuickHuffman.addChar(tmpRoot, 78, 105, 7);
        QuickHuffman.addChar(tmpRoot, 79, 106, 7);
        QuickHuffman.addChar(tmpRoot, 80, 107, 7);
        QuickHuffman.addChar(tmpRoot, 81, 108, 7);
        QuickHuffman.addChar(tmpRoot, 82, 109, 7);
        QuickHuffman.addChar(tmpRoot, 83, 110, 7);
        QuickHuffman.addChar(tmpRoot, 84, 111, 7);
        QuickHuffman.addChar(tmpRoot, 85, 112, 7);
        QuickHuffman.addChar(tmpRoot, 86, 113, 7);
        QuickHuffman.addChar(tmpRoot, 87, 114, 7);
        QuickHuffman.addChar(tmpRoot, 88, 252, 8);
        QuickHuffman.addChar(tmpRoot, 89, 115, 7);
        QuickHuffman.addChar(tmpRoot, 90, 253, 8);
        QuickHuffman.addChar(tmpRoot, 91, 8187, 13);
        QuickHuffman.addChar(tmpRoot, 92, 524272, 19);
        QuickHuffman.addChar(tmpRoot, 93, 8188, 13);
        QuickHuffman.addChar(tmpRoot, 94, 16380, 14);
        QuickHuffman.addChar(tmpRoot, 95, 34, 6);
        QuickHuffman.addChar(tmpRoot, 96, 32765, 15);
        QuickHuffman.addChar(tmpRoot, 97, 3, 5);
        QuickHuffman.addChar(tmpRoot, 98, 35, 6);
        QuickHuffman.addChar(tmpRoot, 99, 4, 5);
        QuickHuffman.addChar(tmpRoot, 100, 36, 6);
        QuickHuffman.addChar(tmpRoot, 101, 5, 5);
        QuickHuffman.addChar(tmpRoot, 102, 37, 6);
        QuickHuffman.addChar(tmpRoot, 103, 38, 6);
        QuickHuffman.addChar(tmpRoot, 104, 39, 6);
        QuickHuffman.addChar(tmpRoot, 105, 6, 5);
        QuickHuffman.addChar(tmpRoot, 106, 116, 7);
        QuickHuffman.addChar(tmpRoot, 107, 117, 7);
        QuickHuffman.addChar(tmpRoot, 108, 40, 6);
        QuickHuffman.addChar(tmpRoot, 109, 41, 6);
        QuickHuffman.addChar(tmpRoot, 110, 42, 6);
        QuickHuffman.addChar(tmpRoot, 111, 7, 5);
        QuickHuffman.addChar(tmpRoot, 112, 43, 6);
        QuickHuffman.addChar(tmpRoot, 113, 118, 7);
        QuickHuffman.addChar(tmpRoot, 114, 44, 6);
        QuickHuffman.addChar(tmpRoot, 115, 8, 5);
        QuickHuffman.addChar(tmpRoot, 116, 9, 5);
        QuickHuffman.addChar(tmpRoot, 117, 45, 6);
        QuickHuffman.addChar(tmpRoot, 118, 119, 7);
        QuickHuffman.addChar(tmpRoot, 119, 120, 7);
        QuickHuffman.addChar(tmpRoot, 120, 121, 7);
        QuickHuffman.addChar(tmpRoot, 121, 122, 7);
        QuickHuffman.addChar(tmpRoot, 122, 123, 7);
        QuickHuffman.addChar(tmpRoot, 123, 32766, 15);
        QuickHuffman.addChar(tmpRoot, 124, 2044, 11);
        QuickHuffman.addChar(tmpRoot, 125, 16381, 14);
        QuickHuffman.addChar(tmpRoot, 126, 8189, 13);
        QuickHuffman.addChar(tmpRoot, 127, 0xFFFFFFC, 28);
        QuickHuffman.addChar(tmpRoot, 128, 1048550, 20);
        QuickHuffman.addChar(tmpRoot, 129, 4194258, 22);
        QuickHuffman.addChar(tmpRoot, 130, 1048551, 20);
        QuickHuffman.addChar(tmpRoot, 131, 1048552, 20);
        QuickHuffman.addChar(tmpRoot, 132, 0x3FFFD3, 22);
        QuickHuffman.addChar(tmpRoot, 133, 4194260, 22);
        QuickHuffman.addChar(tmpRoot, 134, 4194261, 22);
        QuickHuffman.addChar(tmpRoot, 135, 8388569, 23);
        QuickHuffman.addChar(tmpRoot, 136, 4194262, 22);
        QuickHuffman.addChar(tmpRoot, 137, 8388570, 23);
        QuickHuffman.addChar(tmpRoot, 138, 8388571, 23);
        QuickHuffman.addChar(tmpRoot, 139, 8388572, 23);
        QuickHuffman.addChar(tmpRoot, 140, 0x7FFFDD, 23);
        QuickHuffman.addChar(tmpRoot, 141, 8388574, 23);
        QuickHuffman.addChar(tmpRoot, 142, 0xFFFFEB, 24);
        QuickHuffman.addChar(tmpRoot, 143, 0x7FFFDF, 23);
        QuickHuffman.addChar(tmpRoot, 144, 0xFFFFEC, 24);
        QuickHuffman.addChar(tmpRoot, 145, 0xFFFFED, 24);
        QuickHuffman.addChar(tmpRoot, 146, 4194263, 22);
        QuickHuffman.addChar(tmpRoot, 147, 8388576, 23);
        QuickHuffman.addChar(tmpRoot, 148, 0xFFFFEE, 24);
        QuickHuffman.addChar(tmpRoot, 149, 8388577, 23);
        QuickHuffman.addChar(tmpRoot, 150, 8388578, 23);
        QuickHuffman.addChar(tmpRoot, 151, 8388579, 23);
        QuickHuffman.addChar(tmpRoot, 152, 8388580, 23);
        QuickHuffman.addChar(tmpRoot, 153, 2097116, 21);
        QuickHuffman.addChar(tmpRoot, 154, 4194264, 22);
        QuickHuffman.addChar(tmpRoot, 155, 8388581, 23);
        QuickHuffman.addChar(tmpRoot, 156, 4194265, 22);
        QuickHuffman.addChar(tmpRoot, 157, 8388582, 23);
        QuickHuffman.addChar(tmpRoot, 158, 0x7FFFE7, 23);
        QuickHuffman.addChar(tmpRoot, 159, 0xFFFFEF, 24);
        QuickHuffman.addChar(tmpRoot, 160, 4194266, 22);
        QuickHuffman.addChar(tmpRoot, 161, 0x1FFFDD, 21);
        QuickHuffman.addChar(tmpRoot, 162, 1048553, 20);
        QuickHuffman.addChar(tmpRoot, 163, 4194267, 22);
        QuickHuffman.addChar(tmpRoot, 164, 4194268, 22);
        QuickHuffman.addChar(tmpRoot, 165, 8388584, 23);
        QuickHuffman.addChar(tmpRoot, 166, 8388585, 23);
        QuickHuffman.addChar(tmpRoot, 167, 2097118, 21);
        QuickHuffman.addChar(tmpRoot, 168, 8388586, 23);
        QuickHuffman.addChar(tmpRoot, 169, 0x3FFFDD, 22);
        QuickHuffman.addChar(tmpRoot, 170, 4194270, 22);
        QuickHuffman.addChar(tmpRoot, 171, 0xFFFFF0, 24);
        QuickHuffman.addChar(tmpRoot, 172, 0x1FFFDF, 21);
        QuickHuffman.addChar(tmpRoot, 173, 0x3FFFDF, 22);
        QuickHuffman.addChar(tmpRoot, 174, 8388587, 23);
        QuickHuffman.addChar(tmpRoot, 175, 8388588, 23);
        QuickHuffman.addChar(tmpRoot, 176, 2097120, 21);
        QuickHuffman.addChar(tmpRoot, 177, 0x1FFFE1, 21);
        QuickHuffman.addChar(tmpRoot, 178, 4194272, 22);
        QuickHuffman.addChar(tmpRoot, 179, 2097122, 21);
        QuickHuffman.addChar(tmpRoot, 180, 8388589, 23);
        QuickHuffman.addChar(tmpRoot, 181, 4194273, 22);
        QuickHuffman.addChar(tmpRoot, 182, 0x7FFFEE, 23);
        QuickHuffman.addChar(tmpRoot, 183, 0x7FFFEF, 23);
        QuickHuffman.addChar(tmpRoot, 184, 1048554, 20);
        QuickHuffman.addChar(tmpRoot, 185, 4194274, 22);
        QuickHuffman.addChar(tmpRoot, 186, 0x3FFFE3, 22);
        QuickHuffman.addChar(tmpRoot, 187, 4194276, 22);
        QuickHuffman.addChar(tmpRoot, 188, 0x7FFFF0, 23);
        QuickHuffman.addChar(tmpRoot, 189, 4194277, 22);
        QuickHuffman.addChar(tmpRoot, 190, 4194278, 22);
        QuickHuffman.addChar(tmpRoot, 191, 0x7FFFF1, 23);
        QuickHuffman.addChar(tmpRoot, 192, 67108832, 26);
        QuickHuffman.addChar(tmpRoot, 193, 67108833, 26);
        QuickHuffman.addChar(tmpRoot, 194, 1048555, 20);
        QuickHuffman.addChar(tmpRoot, 195, 524273, 19);
        QuickHuffman.addChar(tmpRoot, 196, 4194279, 22);
        QuickHuffman.addChar(tmpRoot, 197, 0x7FFFF2, 23);
        QuickHuffman.addChar(tmpRoot, 198, 4194280, 22);
        QuickHuffman.addChar(tmpRoot, 199, 33554412, 25);
        QuickHuffman.addChar(tmpRoot, 200, 67108834, 26);
        QuickHuffman.addChar(tmpRoot, 201, 0x3FFFFE3, 26);
        QuickHuffman.addChar(tmpRoot, 202, 67108836, 26);
        QuickHuffman.addChar(tmpRoot, 203, 134217694, 27);
        QuickHuffman.addChar(tmpRoot, 204, 0x7FFFFDF, 27);
        QuickHuffman.addChar(tmpRoot, 205, 67108837, 26);
        QuickHuffman.addChar(tmpRoot, 206, 0xFFFFF1, 24);
        QuickHuffman.addChar(tmpRoot, 207, 33554413, 25);
        QuickHuffman.addChar(tmpRoot, 208, 524274, 19);
        QuickHuffman.addChar(tmpRoot, 209, 2097123, 21);
        QuickHuffman.addChar(tmpRoot, 210, 67108838, 26);
        QuickHuffman.addChar(tmpRoot, 211, 134217696, 27);
        QuickHuffman.addChar(tmpRoot, 212, 134217697, 27);
        QuickHuffman.addChar(tmpRoot, 213, 67108839, 26);
        QuickHuffman.addChar(tmpRoot, 214, 134217698, 27);
        QuickHuffman.addChar(tmpRoot, 215, 0xFFFFF2, 24);
        QuickHuffman.addChar(tmpRoot, 216, 2097124, 21);
        QuickHuffman.addChar(tmpRoot, 217, 2097125, 21);
        QuickHuffman.addChar(tmpRoot, 218, 67108840, 26);
        QuickHuffman.addChar(tmpRoot, 219, 67108841, 26);
        QuickHuffman.addChar(tmpRoot, 220, 0xFFFFFFD, 28);
        QuickHuffman.addChar(tmpRoot, 221, 134217699, 27);
        QuickHuffman.addChar(tmpRoot, 222, 134217700, 27);
        QuickHuffman.addChar(tmpRoot, 223, 134217701, 27);
        QuickHuffman.addChar(tmpRoot, 224, 1048556, 20);
        QuickHuffman.addChar(tmpRoot, 225, 0xFFFFF3, 24);
        QuickHuffman.addChar(tmpRoot, 226, 1048557, 20);
        QuickHuffman.addChar(tmpRoot, 227, 2097126, 21);
        QuickHuffman.addChar(tmpRoot, 228, 4194281, 22);
        QuickHuffman.addChar(tmpRoot, 229, 2097127, 21);
        QuickHuffman.addChar(tmpRoot, 230, 2097128, 21);
        QuickHuffman.addChar(tmpRoot, 231, 0x7FFFF3, 23);
        QuickHuffman.addChar(tmpRoot, 232, 4194282, 22);
        QuickHuffman.addChar(tmpRoot, 233, 4194283, 22);
        QuickHuffman.addChar(tmpRoot, 234, 0x1FFFFEE, 25);
        QuickHuffman.addChar(tmpRoot, 235, 0x1FFFFEF, 25);
        QuickHuffman.addChar(tmpRoot, 236, 0xFFFFF4, 24);
        QuickHuffman.addChar(tmpRoot, 237, 0xFFFFF5, 24);
        QuickHuffman.addChar(tmpRoot, 238, 67108842, 26);
        QuickHuffman.addChar(tmpRoot, 239, 0x7FFFF4, 23);
        QuickHuffman.addChar(tmpRoot, 240, 67108843, 26);
        QuickHuffman.addChar(tmpRoot, 241, 134217702, 27);
        QuickHuffman.addChar(tmpRoot, 242, 67108844, 26);
        QuickHuffman.addChar(tmpRoot, 243, 67108845, 26);
        QuickHuffman.addChar(tmpRoot, 244, 0x7FFFFE7, 27);
        QuickHuffman.addChar(tmpRoot, 245, 134217704, 27);
        QuickHuffman.addChar(tmpRoot, 246, 134217705, 27);
        QuickHuffman.addChar(tmpRoot, 247, 134217706, 27);
        QuickHuffman.addChar(tmpRoot, 248, 134217707, 27);
        QuickHuffman.addChar(tmpRoot, 249, 0xFFFFFFE, 28);
        QuickHuffman.addChar(tmpRoot, 250, 134217708, 27);
        QuickHuffman.addChar(tmpRoot, 251, 134217709, 27);
        QuickHuffman.addChar(tmpRoot, 252, 0x7FFFFEE, 27);
        QuickHuffman.addChar(tmpRoot, 253, 0x7FFFFEF, 27);
        QuickHuffman.addChar(tmpRoot, 254, 0x7FFFFF0, 27);
        QuickHuffman.addChar(tmpRoot, 255, 0x3FFFFEE, 26);
        QuickHuffman.addEOS(tmpRoot, 256, 0x3FFFFFFF, 30);
        return ImmutableNode.copyOf(tmpRoot);
    }

    private QuickHuffman() {
    }

    private static void addChar(Node root, int symbol, int code, int bitLength) {
        QuickHuffman.addLeaf(root, (char)symbol, code, bitLength, false);
        long value = (long)code << 64 - bitLength;
        QuickHuffman.codes[symbol] = value | (long)bitLength;
    }

    private static void addEOS(Node root, int symbol, int code, int bitLength) {
        QuickHuffman.addLeaf(root, (char)symbol, code, bitLength, true);
    }

    private static void addLeaf(Node root, char symbol, int code, int bitLength, boolean isEOS) {
        assert (0 < bitLength && bitLength <= 32) : bitLength;
        Node curr = root;
        int nBytes = HPACK.bytesForBits(bitLength);
        int align = (nBytes << 3) - bitLength;
        code <<= align;
        int l = 0;
        int i = 0;
        int probe = 255 << (nBytes - 1 << 3);
        while (i < nBytes - 1) {
            curr.setEOSPath(curr.isEOSPath() | isEOS);
            int idx = (code & probe) >>> (nBytes - 1 - i << 3);
            curr = curr.getOrCreateChild(idx);
            curr.setLength(8);
            l += 8;
            ++i;
            probe >>>= 8;
        }
        int idx = code & 0xFF;
        curr.setEOSPath(curr.isEOSPath() | isEOS);
        for (int i2 = 0; i2 < 1 << align; ++i2) {
            Node child = curr.getOrCreateChild(idx | i2);
            child.setSymbol(symbol);
            child.setEOSPath(child.isEOSPath() | isEOS);
            child.setLength(bitLength - l);
        }
    }

    static final class Writer
    implements Huffman.Writer {
        private final HPACK.BufferUpdateConsumer UPDATER = (buf, bufLen) -> {
            this.buffer = buf;
            this.bufferLen = bufLen;
        };
        private CharSequence source;
        private boolean padded;
        private int pos;
        private int end;
        private long buffer;
        private int bufferLen;

        Writer() {
        }

        @Override
        public Writer from(CharSequence input, int start, int end) {
            this.pos = start;
            this.end = end;
            this.source = input;
            return this;
        }

        @Override
        public boolean write(ByteBuffer destination) {
            while (true) {
                int nBytes;
                if (this.pos < this.end) {
                    char c = this.source.charAt(this.pos);
                    if (c > '\u00ff') {
                        throw new IllegalArgumentException("char=" + c);
                    }
                    long len = QuickHuffman.codeLengthOf(c);
                    if ((long)this.bufferLen + len <= 64L) {
                        this.buffer |= QuickHuffman.codeValueOf(c) >>> this.bufferLen;
                        this.bufferLen = (int)((long)this.bufferLen + len);
                        ++this.pos;
                        continue;
                    }
                }
                if (this.bufferLen == 0) {
                    return true;
                }
                if (this.pos >= this.end && !this.padded) {
                    this.padded = true;
                    if (this.bufferLen != 64) {
                        this.buffer |= -17179869184L >>> this.bufferLen;
                        this.bufferLen = HPACK.bytesForBits(this.bufferLen) << 3;
                    }
                }
                if ((nBytes = HPACK.write(this.buffer, this.bufferLen, this.UPDATER, destination)) == 0) break;
            }
            return false;
        }

        @Override
        public Writer reset() {
            this.source = null;
            this.buffer = 0L;
            this.bufferLen = 0;
            this.end = 0;
            this.pos = 0;
            this.padded = false;
            return this;
        }

        @Override
        public int lengthOf(CharSequence value, int start, int end) {
            int len = 0;
            for (int i = start; i < end; ++i) {
                char c = value.charAt(i);
                len = (int)((long)len + QuickHuffman.codeLengthOf(c));
            }
            return HPACK.bytesForBits(len);
        }
    }

    static final class Reader
    implements Huffman.Reader {
        private final HPACK.BufferUpdateConsumer UPDATER = (buf, bufLen) -> {
            this.buffer = buf;
            this.bufferLen = bufLen;
        };
        private Node curr = QuickHuffman.access$000();
        private long buffer;
        private int bufferLen;
        private int len;
        private boolean done;

        Reader() {
        }

        @Override
        public void read(ByteBuffer source, Appendable destination, boolean isLast) throws IOException {
            while (!this.done) {
                int remaining = source.remaining();
                int nBytes = HPACK.read(source, this.buffer, this.bufferLen, this.UPDATER);
                while (true) {
                    int idx;
                    Node node;
                    if (this.bufferLen < 8) {
                        if (nBytes < remaining) break;
                        if (!isLast) {
                            return;
                        }
                        if (this.bufferLen > 0) {
                            this.buffer |= -72057594037927936L >>> this.bufferLen & 0xFF00000000000000L;
                        } else {
                            this.done = true;
                            break;
                        }
                    }
                    if ((node = this.curr.getChild(idx = (int)(this.buffer >>> 56))) == null) {
                        throw new IOException("Unexpected byte");
                    }
                    if (node.isLeaf()) {
                        if (node.getLength() > this.bufferLen) {
                            throw new IOException("Not a EOS prefix padding or unexpected end of data");
                        }
                        if (node.isEOSPath()) {
                            throw new IOException("Encountered EOS");
                        }
                        destination.append(node.getSymbol());
                        this.curr = root;
                        this.len = 0;
                    } else {
                        this.curr = node;
                        this.len += Math.min(this.bufferLen, node.getLength());
                    }
                    this.buffer <<= node.getLength();
                    this.bufferLen -= node.getLength();
                }
                if (!this.done || !this.curr.isEOSPath() || this.len <= 7) continue;
                throw new IOException("Padding is too long (len=" + this.len + ") or unexpected end of data");
            }
        }

        @Override
        public void reset() {
            this.curr = root;
            this.len = 0;
            this.buffer = 0L;
            this.bufferLen = 0;
            this.done = false;
        }
    }

    static final class ImmutableNode
    implements Node {
        private final char symbol;
        private final boolean eosPath;
        private final int length;
        private final List<ImmutableNode> children;

        public static ImmutableNode copyOf(Node node) {
            if (node.isLeaf()) {
                return new ImmutableNode(node.getSymbol(), node.isEOSPath(), node.getLength());
            }
            Node[] children = node.getChildren();
            ImmutableNode[] immutableChildren = new ImmutableNode[children.length];
            for (int i = 0; i < children.length; ++i) {
                immutableChildren[i] = ImmutableNode.copyOf(children[i]);
            }
            return new ImmutableNode(node.isEOSPath(), node.getLength(), immutableChildren);
        }

        private ImmutableNode(char symbol, boolean eosPath, int length) {
            this.symbol = symbol;
            this.eosPath = eosPath;
            this.length = length;
            this.children = Collections.emptyList();
        }

        private ImmutableNode(boolean eosPath, int length, ImmutableNode[] children) {
            this.symbol = '\u0000';
            this.eosPath = eosPath;
            this.length = length;
            if (children.length == 0) {
                throw new IllegalArgumentException();
            }
            this.children = Arrays.asList(children);
        }

        @Override
        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        @Override
        public boolean isEOSPath() {
            return this.eosPath;
        }

        @Override
        public void setEOSPath(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableNode getChild(int index) {
            return this.children.get(index);
        }

        @Override
        public ImmutableNode getOrCreateChild(int index) {
            throw new UnsupportedOperationException();
        }

        public ImmutableNode[] getChildren() {
            throw new UnsupportedOperationException();
        }

        @Override
        public char getSymbol() {
            return this.symbol;
        }

        @Override
        public void setSymbol(char symbol) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void setLength(int value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class TemporaryNode
    implements Node {
        private char symbol;
        private boolean eosPath;
        private TemporaryNode[] children;
        private int length;

        TemporaryNode() {
        }

        @Override
        public TemporaryNode getOrCreateChild(int index) {
            this.ensureChildrenExist();
            if (this.children[index] == null) {
                this.children[index] = new TemporaryNode();
            }
            return this.children[index];
        }

        private void ensureChildrenExist() {
            if (this.children == null) {
                this.children = new TemporaryNode[256];
            }
        }

        @Override
        public boolean isLeaf() {
            return this.children == null;
        }

        @Override
        public boolean isEOSPath() {
            return this.eosPath;
        }

        @Override
        public void setEOSPath(boolean value) {
            this.eosPath = value;
        }

        @Override
        public TemporaryNode getChild(int index) {
            this.ensureChildrenExist();
            return this.children[index];
        }

        @Override
        public Node[] getChildren() {
            if (this.children == null) {
                return new Node[0];
            }
            return this.children;
        }

        @Override
        public char getSymbol() {
            return this.symbol;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void setSymbol(char value) {
            this.symbol = value;
        }

        @Override
        public void setLength(int value) {
            this.length = value;
        }
    }

    static interface Node {
        public boolean isEOSPath();

        public void setEOSPath(boolean var1);

        public boolean isLeaf();

        public Node getChild(int var1);

        public Node getOrCreateChild(int var1);

        public Node[] getChildren();

        public char getSymbol();

        public void setSymbol(char var1);

        public int getLength();

        public void setLength(int var1);
    }
}

