/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.websocket;

import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.websocket.Decoder;
import org.smartboot.http.common.codec.websocket.PayloadLengthDecoder;
import org.smartboot.http.common.codec.websocket.WebSocket;

public class BasicFrameDecoder
implements Decoder {
    private final Decoder payloadLengthDecoder = new PayloadLengthDecoder();

    @Override
    public Decoder decode(ByteBuffer byteBuffer, WebSocket webSocket) {
        if (byteBuffer.remaining() < 2) {
            return this;
        }
        byte first = byteBuffer.get();
        byte second = byteBuffer.get();
        boolean mask = (second & 0x80) != 0;
        boolean fin = (first & 0x80) != 0;
        int rsv = (first & 0x70) >> 4;
        int opcode = first & 0xF;
        webSocket.setFrameFinalFlag(fin);
        webSocket.setFrameRsv(rsv);
        webSocket.setFrameOpcode(opcode);
        webSocket.setFrameMasked(mask);
        webSocket.setPayloadLength(second & 0x7F);
        return this.payloadLengthDecoder.decode(byteBuffer, webSocket);
    }
}

