/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.graph;

import java.util.IdentityHashMap;
import java.util.Map;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;

public class TreeDependencyVisitor
implements DependencyVisitor {
    private final Map<DependencyNode, Object> visitedNodes;
    private final DependencyVisitor visitor;
    private boolean visited;

    public TreeDependencyVisitor(DependencyVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("no visitor delegate specified");
        }
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
        this.visitor = visitor;
    }

    public boolean visitEnter(DependencyNode node) {
        boolean bl = this.visited = this.visitedNodes.put(node, Boolean.TRUE) != null;
        if (this.visited) {
            return false;
        }
        return this.visitor.visitEnter(node);
    }

    public boolean visitLeave(DependencyNode node) {
        if (this.visited) {
            return true;
        }
        return this.visitor.visitLeave(node);
    }
}

