/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.uploader;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.client.PublisherClient;
import org.sonatype.central.publisher.client.PublisherClientFactory;
import org.sonatype.central.publisher.client.model.PublishingType;
import org.sonatype.central.publisher.plugin.exceptions.DeploymentPublishFailedException;
import org.sonatype.central.publisher.plugin.model.UploadArtifactRequest;
import org.sonatype.central.publisher.plugin.uploader.ArtifactUploader;

@Component(role=ArtifactUploader.class)
public class ArtifactUploaderImpl
extends AbstractLogEnabled
implements ArtifactUploader {
    @Requirement
    private PublisherClient publisherClient;

    public ArtifactUploaderImpl() {
    }

    ArtifactUploaderImpl(PublisherClient publisherClient) {
        this.publisherClient = publisherClient != null ? publisherClient : PublisherClientFactory.createPublisherClient();
    }

    @Override
    public String upload(UploadArtifactRequest uploadArtifactRequest) {
        if (this.getLogger() != null) {
            this.getLogger().info("Going to upload " + uploadArtifactRequest.getBundleFile());
        }
        try {
            String deploymentId = this.publisherClient.upload(uploadArtifactRequest.getDeploymentName(), uploadArtifactRequest.getBundleFile(), uploadArtifactRequest.getPublishingType());
            if (this.getLogger() != null) {
                this.getLogger().info(String.format("Uploaded bundle successfully, deployment name: %s, deploymentId: %s. Deployment will %s", uploadArtifactRequest.getDeploymentName(), deploymentId, this.toPublishingTypeMessage(uploadArtifactRequest)));
            }
            return deploymentId;
        }
        catch (Exception e) {
            if (this.getLogger() != null) {
                this.getLogger().error("Unable to upload bundle for deployment: " + uploadArtifactRequest.getDeploymentName(), (Throwable)e);
            }
            throw new DeploymentPublishFailedException(uploadArtifactRequest.getDeploymentName());
        }
    }

    private String toPublishingTypeMessage(UploadArtifactRequest uploadArtifactRequest) {
        PublishingType publishingType = uploadArtifactRequest.getPublishingType();
        switch (publishingType) {
            case USER_MANAGED: {
                return "require manual publishing";
            }
            case AUTOMATIC: {
                return "publish automatically";
            }
        }
        return "";
    }
}

