/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

class HeaderValueHolder {
    private final List<Object> values = new LinkedList<Object>();

    HeaderValueHolder() {
    }

    void setValue(@Nullable Object value) {
        this.values.clear();
        if (value != null) {
            this.values.add(value);
        }
    }

    void addValue(Object value) {
        this.values.add(value);
    }

    void addValues(Collection<?> values) {
        this.values.addAll(values);
    }

    void addValueArray(Object values) {
        CollectionUtils.mergeArrayIntoCollection((Object)values, this.values);
    }

    List<Object> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    List<String> getStringValues() {
        ArrayList<String> stringList = new ArrayList<String>(this.values.size());
        for (Object value : this.values) {
            stringList.add(value.toString());
        }
        return Collections.unmodifiableList(stringList);
    }

    @Nullable
    Object getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    @Nullable
    String getStringValue() {
        return !this.values.isEmpty() ? String.valueOf(this.values.get(0)) : null;
    }

    public String toString() {
        return this.values.toString();
    }
}

