/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class DockerMcpGatewayContainer
extends GenericContainer<DockerMcpGatewayContainer> {
    private static final String DOCKER_MCP_GATEWAY_IMAGE = "docker/mcp-gateway";
    private static final String DOCKER_AGENTS_GATEWAY_IMAGE = "docker/agents_gateway";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse("docker/mcp-gateway");
    private static final DockerImageName DOCKER_AGENTS_IMAGE_NAME = DockerImageName.parse("docker/agents_gateway");
    private static final int DEFAULT_PORT = 8811;
    private static final String SECRETS_PATH = "/testcontainers/app/secrets";
    private final List<String> servers = new ArrayList<String>();
    private final List<String> tools = new ArrayList<String>();
    private final Map<String, String> secrets = new HashMap<String, String>();

    public DockerMcpGatewayContainer(String dockerImageName) {
        this(DockerImageName.parse(dockerImageName));
    }

    public DockerMcpGatewayContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(DEFAULT_IMAGE_NAME, DOCKER_AGENTS_IMAGE_NAME);
        this.withExposedPorts(new Integer[]{8811});
        this.withFileSystemBind(DockerClientFactory.instance().getRemoteDockerUnixSocketPath(), "/var/run/docker.sock");
        this.waitingFor(Wait.forLogMessage(".*Start sse server on port.*", 1));
    }

    @Override
    protected void configure() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("--transport=sse");
        for (String server : this.servers) {
            if (server.isEmpty()) continue;
            command.add("--servers=" + server);
        }
        for (String tool : this.tools) {
            if (tool.isEmpty()) continue;
            command.add("--tools=" + tool);
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            command.add("--secrets=/testcontainers/app/secrets");
        }
        this.withCommand(String.join((CharSequence)" ", command));
    }

    @Override
    protected void containerIsCreated(String containerId) {
        if (this.secrets != null && !this.secrets.isEmpty()) {
            StringBuilder secretsFile = new StringBuilder();
            for (Map.Entry<String, String> entry : this.secrets.entrySet()) {
                secretsFile.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
            this.copyFileToContainer(Transferable.of(secretsFile.toString()), SECRETS_PATH);
        }
    }

    public DockerMcpGatewayContainer withServer(String server, List<String> tools) {
        this.servers.add(server);
        this.tools.addAll(tools);
        return this;
    }

    public DockerMcpGatewayContainer withServer(String server, String ... tools) {
        this.servers.add(server);
        this.tools.addAll(Arrays.asList(tools));
        return this;
    }

    public DockerMcpGatewayContainer withSecrets(Map<String, String> secrets) {
        this.secrets.putAll(secrets);
        return this;
    }

    public DockerMcpGatewayContainer withSecret(String secretKey, String secretValue) {
        this.secrets.put(secretKey, secretValue);
        return this;
    }

    public String getEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(8811);
    }
}

