/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.SocatContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class DockerModelRunnerContainer
extends SocatContainer {
    private static final Logger log = LoggerFactory.getLogger(DockerModelRunnerContainer.class);
    private static final String MODEL_RUNNER_ENDPOINT = "model-runner.docker.internal";
    private static final int PORT = 80;
    private String model;

    public DockerModelRunnerContainer(String image) {
        this(DockerImageName.parse(image));
    }

    public DockerModelRunnerContainer(DockerImageName image) {
        super(image);
        this.withTarget(80, MODEL_RUNNER_ENDPOINT);
        this.waitingFor(Wait.forHttp("/").forResponsePredicate(res -> res.contains("The service is running")));
    }

    @Override
    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (this.model != null) {
            this.logger().info("Pulling model: {}. Please be patient.", (Object)this.model);
            String url = this.getBaseEndpoint() + "/models/create";
            String payload = String.format("{\"from\": \"%s\"}", this.model);
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(payload.getBytes());
                    os.flush();
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    while (br.readLine() != null) {
                    }
                }
                connection.disconnect();
            }
            catch (IOException e) {
                this.logger().error("Failed to pull model {}: {}", (Object)this.model, (Object)e);
            }
            this.logger().info("Finished pulling model: {}", (Object)this.model);
        }
    }

    public DockerModelRunnerContainer withModel(String model) {
        this.model = model;
        return this;
    }

    public String getBaseEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(80);
    }

    public String getOpenAIEndpoint() {
        return this.getBaseEndpoint() + "/engines";
    }
}

